/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.k8s.parser;

import io.kubernetes.client.informer.cache.Lister;
import io.kubernetes.client.openapi.ApiException;
import io.kubernetes.client.openapi.apis.CoreV1Api;
import io.kubernetes.client.openapi.models.V1EndpointAddress;
import io.kubernetes.client.openapi.models.V1EndpointSubset;
import io.kubernetes.client.openapi.models.V1Endpoints;
import io.kubernetes.client.openapi.models.V1HTTPIngressPath;
import io.kubernetes.client.openapi.models.V1Ingress;
import io.kubernetes.client.openapi.models.V1IngressBackend;
import io.kubernetes.client.openapi.models.V1IngressRule;
import io.kubernetes.client.openapi.models.V1IngressServiceBackend;
import io.kubernetes.client.openapi.models.V1IngressTLS;
import io.kubernetes.client.openapi.models.V1Secret;
import io.kubernetes.client.openapi.models.V1Service;
import io.kubernetes.client.openapi.models.V1ServiceBackendPort;
import java.io.ByteArrayInputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.shenyu.common.config.ssl.SslCrtAndKeyStream;
import org.apache.shenyu.common.dto.ConditionData;
import org.apache.shenyu.common.dto.MetaData;
import org.apache.shenyu.common.dto.RuleData;
import org.apache.shenyu.common.dto.SelectorData;
import org.apache.shenyu.common.dto.convert.rule.impl.DubboRuleHandle;
import org.apache.shenyu.common.dto.convert.selector.DubboUpstream;
import org.apache.shenyu.common.enums.LoadBalanceEnum;
import org.apache.shenyu.common.enums.MatchModeEnum;
import org.apache.shenyu.common.enums.OperatorEnum;
import org.apache.shenyu.common.enums.ParamTypeEnum;
import org.apache.shenyu.common.enums.PluginEnum;
import org.apache.shenyu.common.enums.RpcTypeEnum;
import org.apache.shenyu.common.enums.SelectorTypeEnum;
import org.apache.shenyu.common.utils.GsonUtils;
import org.apache.shenyu.k8s.common.IngressConfiguration;
import org.apache.shenyu.k8s.common.ShenyuMemoryConfig;
import org.apache.shenyu.k8s.parser.K8sResourceParser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DubboIngressParser
implements K8sResourceParser<V1Ingress> {
    private static final Logger LOG = LoggerFactory.getLogger(DubboIngressParser.class);
    private final Lister<V1Service> serviceLister;
    private final Lister<V1Endpoints> endpointsLister;

    public DubboIngressParser(Lister<V1Service> serviceInformer, Lister<V1Endpoints> endpointsInformer) {
        this.serviceLister = serviceInformer;
        this.endpointsLister = endpointsInformer;
    }

    @Override
    public ShenyuMemoryConfig parse(V1Ingress ingress, CoreV1Api coreV1Api) {
        ShenyuMemoryConfig res = new ShenyuMemoryConfig();
        if (Objects.nonNull(ingress.getSpec())) {
            V1IngressBackend dubboBackend = ingress.getSpec().getDefaultBackend();
            List rules = ingress.getSpec().getRules();
            List tlsList = ingress.getSpec().getTls();
            String namespace = Objects.requireNonNull(ingress.getMetadata()).getNamespace();
            List<DubboUpstream> dubboUpstreamList = this.getDefaultDubboRouteConfig(dubboBackend, namespace);
            if (Objects.isNull(rules) || CollectionUtils.isEmpty((Collection)rules)) {
                if (Objects.nonNull(dubboBackend) && Objects.nonNull(dubboBackend.getService())) {
                    IngressConfiguration defaultRouteConfig = this.getDubboRouteConfig(dubboUpstreamList, ingress.getMetadata().getAnnotations());
                    res.setGlobalDefaultBackend((Pair<Pair<String, String>, IngressConfiguration>)Pair.of((Object)Pair.of((Object)(namespace + "/" + ingress.getMetadata().getName()), (Object)dubboBackend.getService().getName()), (Object)defaultRouteConfig));
                }
            } else {
                ArrayList<IngressConfiguration> routeList = new ArrayList<IngressConfiguration>(rules.size());
                for (V1IngressRule ingressRule : rules) {
                    List<IngressConfiguration> routes = this.parseIngressRule(ingressRule, dubboUpstreamList, Objects.requireNonNull(ingress.getMetadata()).getNamespace(), ingress.getMetadata().getAnnotations(), ingress.getMetadata().getLabels());
                    routeList.addAll(routes);
                }
                res.setRouteConfigList(routeList);
            }
            if (Objects.nonNull(tlsList) && CollectionUtils.isNotEmpty((Collection)tlsList)) {
                ArrayList<SslCrtAndKeyStream> sslList = new ArrayList<SslCrtAndKeyStream>();
                for (V1IngressTLS tls : tlsList) {
                    List hosts = tls.getHosts();
                    String secretName = tls.getSecretName();
                    if (!Objects.nonNull(secretName) || !CollectionUtils.isNotEmpty((Collection)hosts)) continue;
                    try {
                        V1Secret secret = coreV1Api.readNamespacedSecret(secretName, namespace, "ture");
                        Map secretData = secret.getData();
                        if (!Objects.nonNull(secretData)) continue;
                        ByteArrayInputStream keyCertChainInputStream = new ByteArrayInputStream((byte[])secretData.get("tls.crt"));
                        ByteArrayInputStream keyInputStream = new ByteArrayInputStream((byte[])secretData.get("tls.key"));
                        hosts.forEach(host -> sslList.add(new SslCrtAndKeyStream(host, keyCertChainInputStream, keyInputStream)));
                    }
                    catch (ApiException e) {
                        LOG.error("parse tls failed ", (Throwable)e);
                    }
                }
                res.setTlsConfigList(sslList);
            }
        }
        return res;
    }

    private List<DubboUpstream> getDefaultDubboRouteConfig(V1IngressBackend defaultBackend, String namespace) {
        ArrayList<DubboUpstream> dubboUpstreamList = new ArrayList<DubboUpstream>();
        if (Objects.nonNull(defaultBackend) && Objects.nonNull(defaultBackend.getService())) {
            String serviceName = defaultBackend.getService().getName();
            V1Endpoints v1Endpoints = (V1Endpoints)this.endpointsLister.namespace(namespace).get(serviceName);
            List subsets = v1Endpoints.getSubsets();
            if (Objects.isNull(subsets) || CollectionUtils.isEmpty((Collection)subsets)) {
                LOG.info("Endpoints {} do not have subsets", (Object)serviceName);
            } else {
                for (V1EndpointSubset subset : subsets) {
                    List addresses = subset.getAddresses();
                    if (Objects.isNull(addresses) || CollectionUtils.isEmpty((Collection)addresses)) continue;
                    for (V1EndpointAddress address : addresses) {
                        String upstreamIp = address.getIp();
                        String defaultPort = this.parsePort(defaultBackend.getService());
                        if (!Objects.nonNull(defaultPort)) continue;
                        DubboUpstream upstream = DubboUpstream.builder().upstreamUrl(upstreamIp + ":" + defaultPort).weight(100).protocol("dubbo://").warmup(0).status(true).upstreamHost("").build();
                        dubboUpstreamList.add(upstream);
                    }
                }
            }
        }
        return dubboUpstreamList;
    }

    private String parsePort(V1IngressServiceBackend service) {
        V1ServiceBackendPort servicePort = service.getPort();
        if (Objects.nonNull(servicePort)) {
            String trim;
            Integer portNumber = servicePort.getNumber();
            if (Objects.nonNull(portNumber) && portNumber > 0) {
                return String.valueOf(portNumber);
            }
            String servicePortName = servicePort.getName();
            if (Objects.nonNull(servicePortName) && StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{trim = servicePortName.trim()})) {
                return trim;
            }
        }
        return null;
    }

    private List<IngressConfiguration> parseIngressRule(V1IngressRule ingressRule, List<DubboUpstream> dubboUpstreamList, String namespace, Map<String, String> annotations, Map<String, String> labels) {
        List paths;
        ConditionData hostCondition;
        ArrayList<IngressConfiguration> res = new ArrayList<IngressConfiguration>();
        ConditionData conditionData = hostCondition = Objects.nonNull(ingressRule.getHost()) ? this.createHostCondition(ingressRule.getHost()) : null;
        if (Objects.nonNull(ingressRule.getHttp()) && Objects.nonNull(paths = ingressRule.getHttp().getPaths())) {
            for (V1HTTPIngressPath path : paths) {
                String pathPath = path.getPath();
                if (Objects.isNull(pathPath)) continue;
                OperatorEnum operator = this.getOperator(path.getPathType());
                ConditionData pathCondition = this.createPathCondition(pathPath, operator);
                ArrayList<ConditionData> conditionList = new ArrayList<ConditionData>(2);
                if (Objects.nonNull(hostCondition)) {
                    conditionList.add(hostCondition);
                }
                conditionList.add(pathCondition);
                List<DubboUpstream> upstreamList = this.parseUpstream(path, namespace, annotations);
                if (upstreamList.isEmpty()) {
                    upstreamList = dubboUpstreamList;
                }
                SelectorData selectorData = this.createSelectorData(pathPath, conditionList, upstreamList);
                ArrayList<RuleData> ruleDataList = new ArrayList<RuleData>();
                ArrayList<MetaData> metaDataList = new ArrayList<MetaData>();
                for (String label : labels.keySet()) {
                    Map metadataAnnotations = ((V1Service)this.serviceLister.namespace(namespace).get(labels.get(label))).getMetadata().getAnnotations();
                    DubboRuleHandle ruleHandle = this.createDubboRuleHandle(annotations);
                    List<ConditionData> ruleConditionList = this.getRuleConditionList(metadataAnnotations);
                    RuleData ruleData = this.createRuleData(metadataAnnotations, ruleHandle, ruleConditionList);
                    MetaData metaData = this.parseMetaData(metadataAnnotations);
                    ruleDataList.add(ruleData);
                    metaDataList.add(metaData);
                }
                res.add(new IngressConfiguration(selectorData, ruleDataList, metaDataList));
            }
        }
        return res;
    }

    private List<ConditionData> getRuleConditionList(Map<String, String> annotations) {
        ArrayList<ConditionData> ruleConditionList = new ArrayList<ConditionData>();
        ConditionData ruleCondition = new ConditionData();
        ruleCondition.setOperator(OperatorEnum.EQ.getAlias());
        ruleCondition.setParamType(ParamTypeEnum.URI.getName());
        ruleCondition.setParamValue(annotations.get("shenyu.apache.org/plugin-dubbo-path"));
        ruleConditionList.add(ruleCondition);
        return ruleConditionList;
    }

    private ConditionData createHostCondition(String host) {
        ConditionData hostCondition = new ConditionData();
        hostCondition.setParamType(ParamTypeEnum.DOMAIN.getName());
        hostCondition.setOperator(OperatorEnum.EQ.getAlias());
        hostCondition.setParamValue(host);
        return hostCondition;
    }

    private OperatorEnum getOperator(String pathType) {
        if ("ImplementationSpecific".equals(pathType)) {
            return OperatorEnum.MATCH;
        }
        if ("Prefix".equals(pathType)) {
            return OperatorEnum.STARTS_WITH;
        }
        if ("Exact".equals(pathType)) {
            return OperatorEnum.EQ;
        }
        LOG.info("Invalid path type, set it with match operator");
        return OperatorEnum.MATCH;
    }

    private ConditionData createPathCondition(String path, OperatorEnum operator) {
        ConditionData pathCondition = new ConditionData();
        pathCondition.setOperator(operator.getAlias());
        pathCondition.setParamType(ParamTypeEnum.URI.getName());
        pathCondition.setParamValue(path);
        return pathCondition;
    }

    private DubboRuleHandle createDubboRuleHandle(Map<String, String> annotations) {
        DubboRuleHandle dubboRuleHandle = new DubboRuleHandle();
        if (Objects.nonNull(annotations)) {
            dubboRuleHandle.setLoadBalance(annotations.getOrDefault("shenyu.apache.org/loadbalancer", LoadBalanceEnum.RANDOM.getName()));
            dubboRuleHandle.setTimeout(Long.parseLong(annotations.getOrDefault("shenyu.apache.org/timeout", "3000")));
            dubboRuleHandle.setRetries(Integer.valueOf(Integer.parseInt(annotations.getOrDefault("shenyu.apache.org/retry", "3"))));
        }
        return dubboRuleHandle;
    }

    private SelectorData createSelectorData(String path, List<ConditionData> conditionList, List<DubboUpstream> upstreamList) {
        return SelectorData.builder().pluginId(String.valueOf(PluginEnum.DUBBO.getCode())).pluginName(PluginEnum.DUBBO.getName()).name(path).matchMode(Integer.valueOf(MatchModeEnum.AND.getCode())).type(Integer.valueOf(SelectorTypeEnum.CUSTOM_FLOW.getCode())).enabled(Boolean.valueOf(true)).logged(Boolean.valueOf(false)).continued(Boolean.valueOf(true)).conditionList(conditionList).handle(GsonUtils.getInstance().toJson(upstreamList)).build();
    }

    private RuleData createRuleData(Map<String, String> metadataAnnotations, DubboRuleHandle ruleHandle, List<ConditionData> ruleConditionList) {
        return RuleData.builder().name(metadataAnnotations.get("shenyu.apache.org/plugin-dubbo-path")).pluginName(PluginEnum.DUBBO.getName()).matchMode(Integer.valueOf(MatchModeEnum.AND.getCode())).conditionDataList(ruleConditionList).handle(GsonUtils.getInstance().toJson((Object)ruleHandle)).loged(Boolean.valueOf(true)).enabled(Boolean.valueOf(true)).build();
    }

    private List<DubboUpstream> parseUpstream(V1HTTPIngressPath path, String namespace, Map<String, String> annotations) {
        ArrayList<DubboUpstream> upstreamList = new ArrayList<DubboUpstream>();
        if (Objects.nonNull(path) && Objects.nonNull(path.getBackend().getService()) && Objects.nonNull(path.getBackend().getService().getName())) {
            String serviceName = path.getBackend().getService().getName();
            V1Endpoints v1Endpoints = (V1Endpoints)this.endpointsLister.namespace(namespace).get(serviceName);
            List subsets = v1Endpoints.getSubsets();
            String[] protocols = annotations.get("shenyu.apache.org/upstreams-protocol").split(",");
            if (Objects.isNull(subsets) || CollectionUtils.isEmpty((Collection)subsets)) {
                LOG.info("Endpoints {} do not have subsets", (Object)serviceName);
            } else {
                for (V1EndpointSubset subset : subsets) {
                    List addresses = subset.getAddresses();
                    if (Objects.isNull(addresses) || addresses.isEmpty()) continue;
                    int i = 0;
                    for (V1EndpointAddress address : addresses) {
                        String upstreamIp = address.getIp();
                        String defaultPort = this.parsePort(path.getBackend().getService());
                        if (!Objects.nonNull(defaultPort)) continue;
                        DubboUpstream upstream = DubboUpstream.builder().upstreamUrl(upstreamIp + ":" + defaultPort).weight(100).protocol(Objects.isNull(protocols[i++]) ? "dubbo://" : protocols[i++]).warmup(0).status(true).upstreamHost("").build();
                        upstreamList.add(upstream);
                    }
                }
            }
        }
        return upstreamList;
    }

    private MetaData parseMetaData(Map<String, String> annotations) {
        return MetaData.builder().appName(annotations.get("shenyu.apache.org/plugin-dubbo-app-name")).path(annotations.get("shenyu.apache.org/plugin-dubbo-path")).rpcType(annotations.get("shenyu.apache.org/plugin-dubbo-rpc-type")).rpcExt(annotations.get("shenyu.apache.org/plugin-dubbo-rpc-expand")).serviceName(annotations.get("shenyu.apache.org/plugin-dubbo-service-name")).methodName(annotations.get("shenyu.apache.org/plugin-dubbo-method-name")).parameterTypes(annotations.get("shenyu.apache.org/plugin-dubbo-params-type")).enabled(Boolean.valueOf(true)).build();
    }

    private IngressConfiguration getDubboRouteConfig(List<DubboUpstream> dubboUpstreamList, Map<String, String> annotations) {
        ConditionData conditionData = new ConditionData();
        conditionData.setParamName("dubbo");
        conditionData.setParamType(ParamTypeEnum.URI.getName());
        conditionData.setOperator(OperatorEnum.PATH_PATTERN.getAlias());
        conditionData.setParamValue("/**");
        SelectorData selectorData = SelectorData.builder().name("dubbo-selector").sort(Integer.valueOf(Integer.MAX_VALUE)).conditionList(Collections.singletonList(conditionData)).handle(GsonUtils.getInstance().toJson(dubboUpstreamList)).enabled(Boolean.valueOf(true)).id("1").pluginName(PluginEnum.DUBBO.getName()).pluginId(String.valueOf(PluginEnum.DUBBO.getCode())).logged(Boolean.valueOf(false)).continued(Boolean.valueOf(true)).matchMode(Integer.valueOf(MatchModeEnum.AND.getCode())).type(Integer.valueOf(SelectorTypeEnum.FULL_FLOW.getCode())).build();
        RuleData ruleData = RuleData.builder().selectorId("1").pluginName(PluginEnum.DUBBO.getName()).name("dubbo-rule").matchMode(Integer.valueOf(MatchModeEnum.AND.getCode())).conditionDataList(Collections.singletonList(conditionData)).loged(Boolean.valueOf(false)).enabled(Boolean.valueOf(true)).sort(Integer.valueOf(Integer.MAX_VALUE)).build();
        MetaData metaData = new MetaData();
        if (Objects.nonNull(annotations)) {
            metaData.setAppName(annotations.getOrDefault("shenyu.apache.org/plugin-dubbo-app-name", "dubbo"));
            metaData.setMethodName(annotations.getOrDefault("shenyu.apache.org/plugin-dubbo-method-name", "methodName"));
            metaData.setPath(annotations.getOrDefault("shenyu.apache.org/plugin-dubbo-path", "/dubbo/findAll"));
            metaData.setRpcType(annotations.getOrDefault("shenyu.apache.org/plugin-dubbo-rpc-type", RpcTypeEnum.DUBBO.getName()));
            metaData.setServiceName(annotations.getOrDefault("shenyu.apache.org/plugin-dubbo-service-name", "dubboService"));
            metaData.setContextPath(annotations.getOrDefault("shenyu.apache.org/plugin-dubbo-context-path", "contextPath"));
            metaData.setRpcExt(annotations.getOrDefault("shenyu.apache.org/plugin-dubbo-rpc-ext", "rpcExt"));
            metaData.setServiceName(annotations.getOrDefault("shenyu.apache.org/plugin-dubbo-service-name", "serviceName"));
            metaData.setParameterTypes(annotations.getOrDefault("shenyu.apache.org/plugin-dubbo-parament-type", ""));
            metaData.setEnabled(Boolean.valueOf(Boolean.parseBoolean(annotations.getOrDefault("shenyu.apache.org/plugin-dubbo-enabled", "true"))));
        }
        return new IngressConfiguration(selectorData, Arrays.asList(ruleData), Arrays.asList(metaData));
    }
}

