/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.k8s.parser;

import io.kubernetes.client.informer.cache.Lister;
import io.kubernetes.client.openapi.apis.CoreV1Api;
import io.kubernetes.client.openapi.models.V1Endpoints;
import io.kubernetes.client.openapi.models.V1HTTPIngressPath;
import io.kubernetes.client.openapi.models.V1Ingress;
import io.kubernetes.client.openapi.models.V1IngressRule;
import io.kubernetes.client.openapi.models.V1Service;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.shenyu.common.dto.ConditionData;
import org.apache.shenyu.common.dto.RuleData;
import org.apache.shenyu.common.dto.SelectorData;
import org.apache.shenyu.common.dto.convert.rule.impl.ContextMappingRuleHandle;
import org.apache.shenyu.common.enums.MatchModeEnum;
import org.apache.shenyu.common.enums.OperatorEnum;
import org.apache.shenyu.common.enums.ParamTypeEnum;
import org.apache.shenyu.common.enums.PluginEnum;
import org.apache.shenyu.common.enums.SelectorTypeEnum;
import org.apache.shenyu.common.utils.GsonUtils;
import org.apache.shenyu.k8s.common.IngressConfiguration;
import org.apache.shenyu.k8s.common.ShenyuMemoryConfig;
import org.apache.shenyu.k8s.parser.K8sResourceParser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ContextPathParser
implements K8sResourceParser<V1Ingress> {
    private static final Logger LOG = LoggerFactory.getLogger(ContextPathParser.class);
    private final Lister<V1Service> serviceLister;
    private final Lister<V1Endpoints> endpointsLister;

    public ContextPathParser(Lister<V1Service> serviceLister, Lister<V1Endpoints> endpointsLister) {
        this.serviceLister = serviceLister;
        this.endpointsLister = endpointsLister;
    }

    @Override
    public ShenyuMemoryConfig parse(V1Ingress ingress, CoreV1Api coreV1Api) {
        List rules;
        ShenyuMemoryConfig res = new ShenyuMemoryConfig();
        if (Objects.nonNull(ingress.getSpec()) && Objects.nonNull(rules = ingress.getSpec().getRules())) {
            ArrayList<IngressConfiguration> routeList = new ArrayList<IngressConfiguration>(rules.size());
            for (V1IngressRule ingressRule : rules) {
                List<IngressConfiguration> routes = this.parseIngressRule(ingressRule, ingress.getMetadata().getAnnotations());
                routeList.addAll(routes);
            }
            res.setRouteConfigList(routeList);
        }
        return res;
    }

    private List<IngressConfiguration> parseIngressRule(V1IngressRule ingressRule, Map<String, String> annotations) {
        List paths;
        ConditionData hostCondition;
        ArrayList<IngressConfiguration> res = new ArrayList<IngressConfiguration>();
        ConditionData conditionData = hostCondition = Objects.nonNull(ingressRule.getHost()) ? this.createHostCondition(ingressRule.getHost()) : null;
        if (Objects.nonNull(ingressRule.getHttp()) && Objects.nonNull(paths = ingressRule.getHttp().getPaths())) {
            for (V1HTTPIngressPath path : paths) {
                String pathPath = path.getPath();
                if (Objects.isNull(pathPath)) continue;
                OperatorEnum operator = this.getOperator(path.getPathType());
                ConditionData pathCondition = this.createPathCondition(pathPath, operator);
                ArrayList<ConditionData> conditionList = new ArrayList<ConditionData>(2);
                if (Objects.nonNull(hostCondition)) {
                    conditionList.add(hostCondition);
                }
                conditionList.add(pathCondition);
                SelectorData selectorData = this.createSelectorData(pathPath, conditionList);
                ContextMappingRuleHandle contextMappingRuleHandle = this.createContextMappingRuleHandle(annotations);
                ArrayList<RuleData> ruleDataList = new ArrayList<RuleData>();
                List<ConditionData> ruleConditionList = this.getRuleConditionList(annotations);
                RuleData ruleData = this.createRuleData(annotations, contextMappingRuleHandle, ruleConditionList);
                ruleDataList.add(ruleData);
                res.add(new IngressConfiguration(selectorData, ruleDataList, null));
            }
        }
        return res;
    }

    private ConditionData createHostCondition(String host) {
        ConditionData hostCondition = new ConditionData();
        hostCondition.setParamType(ParamTypeEnum.DOMAIN.getName());
        hostCondition.setOperator(OperatorEnum.EQ.getAlias());
        hostCondition.setParamValue(host);
        return hostCondition;
    }

    private OperatorEnum getOperator(String pathType) {
        if ("ImplementationSpecific".equals(pathType)) {
            return OperatorEnum.MATCH;
        }
        if ("Prefix".equals(pathType)) {
            return OperatorEnum.STARTS_WITH;
        }
        if ("Exact".equals(pathType)) {
            return OperatorEnum.EQ;
        }
        LOG.info("Invalid path type, set it with match operator");
        return OperatorEnum.MATCH;
    }

    private ConditionData createPathCondition(String path, OperatorEnum operator) {
        ConditionData pathCondition = new ConditionData();
        pathCondition.setOperator(operator.getAlias());
        pathCondition.setParamType(ParamTypeEnum.URI.getName());
        pathCondition.setParamValue(path);
        return pathCondition;
    }

    private SelectorData createSelectorData(String path, List<ConditionData> conditionList) {
        return SelectorData.builder().pluginId(String.valueOf(PluginEnum.CONTEXT_PATH.getCode())).pluginName(PluginEnum.CONTEXT_PATH.getName()).name(path).matchMode(Integer.valueOf(MatchModeEnum.AND.getCode())).type(Integer.valueOf(SelectorTypeEnum.CUSTOM_FLOW.getCode())).enabled(Boolean.valueOf(true)).logged(Boolean.valueOf(false)).continued(Boolean.valueOf(true)).conditionList(conditionList).build();
    }

    private ContextMappingRuleHandle createContextMappingRuleHandle(Map<String, String> annotations) {
        ContextMappingRuleHandle ruleHandle = new ContextMappingRuleHandle();
        ruleHandle.setContextPath(annotations.get("shenyu.apache.org/plugin-context-path-path"));
        ruleHandle.setAddPrefix(annotations.get("shenyu.apache.org/plugin-context-path-add-prefix"));
        ruleHandle.setAddPrefixed(Boolean.parseBoolean(annotations.getOrDefault("shenyu.apache.org/plugin-context-path-add-prefixed", "false")));
        return ruleHandle;
    }

    private RuleData createRuleData(Map<String, String> annotations, ContextMappingRuleHandle ruleHandle, List<ConditionData> ruleConditionList) {
        return RuleData.builder().name(annotations.get("shenyu.apache.org/plugin-context-path-path")).pluginName(PluginEnum.CONTEXT_PATH.getName()).matchMode(Integer.valueOf(MatchModeEnum.AND.getCode())).conditionDataList(ruleConditionList).handle(GsonUtils.getInstance().toJson((Object)ruleHandle)).loged(Boolean.valueOf(true)).enabled(Boolean.valueOf(true)).build();
    }

    private List<ConditionData> getRuleConditionList(Map<String, String> annotations) {
        ArrayList<ConditionData> ruleConditionList = new ArrayList<ConditionData>();
        ConditionData ruleCondition = new ConditionData();
        ruleCondition.setOperator(OperatorEnum.PATH_PATTERN.getAlias());
        ruleCondition.setParamType(ParamTypeEnum.URI.getName());
        ruleCondition.setParamValue(annotations.get("shenyu.apache.org/plugin-context-path-path") + "/**");
        ruleConditionList.add(ruleCondition);
        return ruleConditionList;
    }
}

