/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.k8s.cache;

import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.shenyu.k8s.cache.SelectorCache;

public final class IngressSelectorCache
implements SelectorCache {
    private static final IngressSelectorCache INSTANCE = new IngressSelectorCache();
    private static final Map<String, List<String>> SELECTOR_MAP = Maps.newConcurrentMap();
    private static final AtomicLong GROWING_ID = new AtomicLong(10L);

    private IngressSelectorCache() {
    }

    public static IngressSelectorCache getInstance() {
        return INSTANCE;
    }

    @Override
    public List<String> put(String namespace, String name, String pluginName, List<String> selectorIdList) {
        return SELECTOR_MAP.put(this.getKey(namespace, name, pluginName), selectorIdList);
    }

    public List<String> put(String namespace, String name, String pluginName, String selectorId) {
        List selectorIdList = SELECTOR_MAP.computeIfAbsent(this.getKey(namespace, name, pluginName), k -> new ArrayList());
        selectorIdList.add(selectorId);
        return SELECTOR_MAP.put(this.getKey(namespace, name, pluginName), selectorIdList);
    }

    @Override
    public List<String> get(String namespace, String name, String pluginName) {
        return SELECTOR_MAP.get(this.getKey(namespace, name, pluginName));
    }

    @Override
    public List<String> remove(String namespace, String name, String pluginName) {
        return SELECTOR_MAP.remove(this.getKey(namespace, name, pluginName));
    }

    public String generateSelectorId() {
        return String.valueOf(GROWING_ID.getAndIncrement());
    }

    public String generateRuleId() {
        return String.valueOf(GROWING_ID.getAndIncrement());
    }

    public String generateMetaDataId() {
        return String.valueOf(GROWING_ID.getAndIncrement());
    }

    private String getKey(String namespace, String name, String pluginName) {
        return String.format("%s-%s-%s", namespace, name, pluginName);
    }
}

