/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.client.springmvc.proceeor.extractor;

import java.util.List;
import java.util.Objects;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.shenyu.client.core.register.ApiBean;
import org.apache.shenyu.client.core.register.matcher.ApiAnnotationProcessor;
import org.apache.shenyu.client.core.register.matcher.ExtractorProcessor;
import org.apache.shenyu.common.enums.RpcTypeEnum;
import org.apache.shenyu.common.utils.ListUtil;
import org.springframework.lang.NonNull;
import org.springframework.web.bind.annotation.RequestMapping;

public class RequestMappingProcessor
implements ApiAnnotationProcessor<RequestMapping>,
ExtractorProcessor {
    public List<String> supportedClient() {
        return ListUtil.of((Object[])new String[]{RpcTypeEnum.HTTP.getName()});
    }

    public void process(ApiBean api, RequestMapping annotation) {
        String beanPath = Objects.isNull(annotation) ? "" : this.getPath(annotation);
        api.setBeanPath(beanPath);
        if (Objects.nonNull(annotation)) {
            api.addProperties("consumes", String.join((CharSequence)",", annotation.consumes()));
            api.addProperties("produces", String.join((CharSequence)",", annotation.produces()));
        }
    }

    public void process(ApiBean.ApiDefinition definition, RequestMapping annotation) {
        definition.setMethodPath(this.getPath(annotation));
        definition.addProperties("consumes", String.join((CharSequence)",", annotation.consumes()));
        definition.addProperties("produces", String.join((CharSequence)",", annotation.produces()));
        definition.addProperties("desc", definition.getApiMethodName());
        definition.addProperties("rule", "");
        definition.addProperties("value", this.getPath(annotation));
    }

    public Class<RequestMapping> matchAnnotation() {
        return RequestMapping.class;
    }

    private String getPath(@NonNull RequestMapping requestMapping) {
        if (ArrayUtils.isEmpty((Object[])requestMapping.path())) {
            return "";
        }
        return requestMapping.path()[0];
    }
}

