/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.client.springmvc.init;

import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Properties;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.shenyu.client.core.client.AbstractContextRefreshedEventListener;
import org.apache.shenyu.client.core.disruptor.ShenyuClientRegisterEventPublisher;
import org.apache.shenyu.client.core.utils.PortUtils;
import org.apache.shenyu.client.springmvc.annotation.ShenyuSpringMvcClient;
import org.apache.shenyu.common.enums.ApiHttpMethodEnum;
import org.apache.shenyu.common.enums.RpcTypeEnum;
import org.apache.shenyu.common.exception.ShenyuException;
import org.apache.shenyu.common.utils.PathUtils;
import org.apache.shenyu.register.client.api.ShenyuClientRegisterRepository;
import org.apache.shenyu.register.common.config.ShenyuClientConfig;
import org.apache.shenyu.register.common.dto.ApiDocRegisterDTO;
import org.apache.shenyu.register.common.dto.MetaDataRegisterDTO;
import org.apache.shenyu.register.common.dto.URIRegisterDTO;
import org.apache.shenyu.register.common.enums.EventType;
import org.apache.shenyu.register.common.type.DataTypeParent;
import org.javatuples.Sextet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.core.annotation.AnnotatedElementUtils;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.core.env.Environment;
import org.springframework.lang.NonNull;
import org.springframework.lang.Nullable;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.util.UriComponentsBuilder;

public class SpringMvcClientEventListener
extends AbstractContextRefreshedEventListener<Object, ShenyuSpringMvcClient> {
    private static final Logger LOG = LoggerFactory.getLogger(SpringMvcClientEventListener.class);
    private final ShenyuClientRegisterEventPublisher publisher = ShenyuClientRegisterEventPublisher.getInstance();
    private final List<Class<? extends Annotation>> mappingAnnotation = new ArrayList<Class<? extends Annotation>>(3);
    private final Boolean isFull;
    private final String protocol;
    private final boolean addPrefixed;
    private final Environment env;

    public SpringMvcClientEventListener(ShenyuClientConfig clientConfig, ShenyuClientRegisterRepository shenyuClientRegisterRepository, Environment env) {
        super(clientConfig, shenyuClientRegisterRepository);
        this.env = env;
        Properties props = ((ShenyuClientConfig.ClientPropertiesConfig)clientConfig.getClient().get(this.getClientName())).getProps();
        this.isFull = Boolean.parseBoolean(props.getProperty("isFull", Boolean.FALSE.toString()));
        this.protocol = props.getProperty("protocol", "http://");
        this.addPrefixed = Boolean.parseBoolean(props.getProperty("addPrefixed", Boolean.FALSE.toString()));
        this.mappingAnnotation.add(ShenyuSpringMvcClient.class);
        this.mappingAnnotation.add(RequestMapping.class);
    }

    protected Sextet<String[], String, String, ApiHttpMethodEnum[], RpcTypeEnum, String> buildApiDocSextet(Method method, Annotation annotation, Map<String, Object> beans) {
        RequestMapping requestMapping = (RequestMapping)AnnotatedElementUtils.findMergedAnnotation((AnnotatedElement)method, RequestMapping.class);
        String produce = requestMapping.produces().length == 0 ? "*/*" : String.join((CharSequence)",", requestMapping.produces());
        String consume = requestMapping.consumes().length == 0 ? "*/*" : String.join((CharSequence)",", requestMapping.consumes());
        String[] values = requestMapping.value();
        RequestMethod[] requestMethods = requestMapping.method();
        if (requestMethods.length == 0) {
            requestMethods = RequestMethod.values();
        }
        List<ApiHttpMethodEnum> collect = Stream.of(requestMethods).map(item -> ApiHttpMethodEnum.of((String)item.name())).collect(Collectors.toList());
        ApiHttpMethodEnum[] apiHttpMethodEnums = collect.toArray(new ApiHttpMethodEnum[0]);
        String version = "v0.01";
        return Sextet.with((Object)values, (Object)consume, (Object)produce, (Object)apiHttpMethodEnums, (Object)RpcTypeEnum.HTTP, (Object)version);
    }

    protected Map<String, Object> getBeans(ApplicationContext context) {
        if (Boolean.TRUE.equals(this.isFull)) {
            LOG.info("init spring mvc client success with isFull mode");
            List namespaceIds = super.getNamespace();
            namespaceIds.forEach(namespaceId -> {
                this.getPublisher().publishEvent((DataTypeParent)MetaDataRegisterDTO.builder().contextPath(this.getContextPath()).addPrefixed(this.addPrefixed).appName(this.getAppName()).path(UriComponentsBuilder.fromUriString((String)(PathUtils.decoratorPathWithSlash((String)this.getContextPath()) + "**")).build().encode().toUriString()).rpcType(RpcTypeEnum.HTTP.getName()).enabled(true).ruleName(this.getContextPath()).namespaceId(namespaceId).build());
                this.publisher.publishEvent((DataTypeParent)this.buildURIRegisterDTO(context, Collections.emptyMap(), (String)namespaceId));
            });
            return Collections.emptyMap();
        }
        return context.getBeansWithAnnotation(Controller.class);
    }

    protected URIRegisterDTO buildURIRegisterDTO(ApplicationContext context, Map<String, Object> beans, String namespaceId) {
        try {
            return URIRegisterDTO.builder().contextPath(this.getContextPath()).appName(this.getAppName()).protocol(this.protocol).host(super.getHost()).port(Integer.valueOf(this.getPort())).rpcType(RpcTypeEnum.HTTP.getName()).eventType(EventType.REGISTER).namespaceId(namespaceId).build();
        }
        catch (ShenyuException e) {
            throw new ShenyuException(e.getMessage() + "please config ${shenyu.client.http.props.port} in xml/yml !");
        }
    }

    protected String getClientName() {
        return RpcTypeEnum.HTTP.getName();
    }

    protected String buildApiSuperPath(Class<?> clazz, @Nullable ShenyuSpringMvcClient beanShenyuClient) {
        String servletPath = StringUtils.defaultString((String)this.env.getProperty("spring.mvc.servlet.path"), (String)"");
        String servletContextPath = StringUtils.defaultString((String)this.env.getProperty("server.servlet.context-path"), (String)"");
        String rootPath = String.format("/%s/%s/", servletContextPath, servletPath);
        if (Objects.nonNull(beanShenyuClient) && StringUtils.isNotBlank((CharSequence)beanShenyuClient.path()[0])) {
            return this.formatPath(String.format("%s/%s", rootPath, beanShenyuClient.path()[0]));
        }
        RequestMapping requestMapping = (RequestMapping)AnnotationUtils.findAnnotation(clazz, RequestMapping.class);
        if (Objects.nonNull(requestMapping) && ArrayUtils.isNotEmpty((Object[])requestMapping.path()) && StringUtils.isNotBlank((CharSequence)requestMapping.path()[0])) {
            return this.formatPath(String.format("%s/%s", rootPath, requestMapping.path()[0]));
        }
        return this.formatPath(rootPath);
    }

    protected Class<ShenyuSpringMvcClient> getAnnotationType() {
        return ShenyuSpringMvcClient.class;
    }

    protected void handleMethod(Object bean, Class<?> clazz, @Nullable ShenyuSpringMvcClient beanShenyuClient, Method method, String superPath) {
        RequestMapping requestMapping = (RequestMapping)AnnotatedElementUtils.findMergedAnnotation((AnnotatedElement)method, RequestMapping.class);
        ShenyuSpringMvcClient methodShenyuClient = (ShenyuSpringMvcClient)AnnotatedElementUtils.findMergedAnnotation((AnnotatedElement)method, ShenyuSpringMvcClient.class);
        ShenyuSpringMvcClient shenyuSpringMvcClient = methodShenyuClient = Objects.isNull(methodShenyuClient) ? beanShenyuClient : methodShenyuClient;
        if (Objects.nonNull(methodShenyuClient) && Objects.nonNull(requestMapping)) {
            List namespaceIds = super.getNamespace();
            for (String namespaceId : namespaceIds) {
                MetaDataRegisterDTO metaData = this.buildMetaDataDTO(bean, methodShenyuClient, this.buildApiPath(method, superPath, methodShenyuClient), clazz, method, namespaceId);
                this.getPublisher().publishEvent((DataTypeParent)metaData);
                this.getMetaDataMap().put(method, metaData);
            }
        }
    }

    protected String buildApiPath(Method method, String superPath, @NonNull ShenyuSpringMvcClient methodShenyuClient) {
        String contextPath = this.getContextPath();
        if (StringUtils.isNotBlank((CharSequence)methodShenyuClient.path()[0])) {
            return this.pathJoin(new String[]{contextPath, superPath, methodShenyuClient.path()[0]});
        }
        String path = this.getPathByMethod(method);
        if (StringUtils.isNotBlank((CharSequence)path)) {
            return this.pathJoin(new String[]{contextPath, superPath, path});
        }
        return this.pathJoin(new String[]{contextPath, superPath});
    }

    private String formatPath(String path) {
        return path.replaceAll("/+", "/").replaceFirst("/$", "");
    }

    private String getPathByMethod(@NonNull Method method) {
        for (Class<? extends Annotation> mapping : this.mappingAnnotation) {
            String pathByAnnotation = this.getPathByAnnotation(AnnotatedElementUtils.findMergedAnnotation((AnnotatedElement)method, mapping));
            if (!StringUtils.isNotBlank((CharSequence)pathByAnnotation)) continue;
            return pathByAnnotation;
        }
        return null;
    }

    private String getPathByAnnotation(@Nullable Annotation annotation) {
        if (Objects.isNull(annotation)) {
            return null;
        }
        Object value = AnnotationUtils.getValue((Annotation)annotation, (String)"value");
        if (value instanceof String && StringUtils.isNotBlank((CharSequence)((String)value))) {
            return (String)value;
        }
        if (value instanceof String[] && ArrayUtils.isNotEmpty((Object[])((String[])value)) && StringUtils.isNotBlank((CharSequence)((String[])value)[0])) {
            return ((String[])value)[0];
        }
        return null;
    }

    protected MetaDataRegisterDTO buildMetaDataDTO(Object bean, @NonNull ShenyuSpringMvcClient shenyuClient, String path, Class<?> clazz, Method method, String namespaceId) {
        return MetaDataRegisterDTO.builder().contextPath(this.getContextPath()).addPrefixed(this.addPrefixed).appName(this.getAppName()).serviceName(clazz.getName()).methodName((String)Optional.ofNullable(method).map(Method::getName).orElse(null)).path(UriComponentsBuilder.fromUriString((String)path).build().encode().toUriString()).pathDesc(shenyuClient.desc()).parameterTypes((String)Optional.ofNullable(method).map(m -> Arrays.stream(m.getParameterTypes()).map(Class::getName).collect(Collectors.joining(","))).orElse(null)).rpcType(RpcTypeEnum.HTTP.getName()).enabled(shenyuClient.enabled()).ruleName((String)StringUtils.defaultIfBlank((CharSequence)shenyuClient.ruleName(), (CharSequence)path)).registerMetaData(shenyuClient.registerMetaData()).namespaceId(namespaceId).build();
    }

    protected ApiDocRegisterDTO.ApiExt customApiDocExt(ApiDocRegisterDTO.ApiExt ext) {
        ext.setProtocol(this.protocol);
        ext.setAddPrefixed(this.addPrefixed);
        return ext;
    }

    public String getPort() {
        int port = Integer.parseInt(Optional.ofNullable(super.getPort()).orElse("-1"));
        int mergedPort = port <= 0 ? PortUtils.findPort((BeanFactory)this.getContext().getAutowireCapableBeanFactory()) : port;
        return String.valueOf(mergedPort);
    }
}

