/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.client.grpc.json;

import com.google.protobuf.DynamicMessage;
import com.google.protobuf.Message;
import com.google.protobuf.util.JsonFormat;
import io.grpc.ForwardingServerCallListener;
import io.grpc.ServerCall;
import io.grpc.Status;
import java.util.Objects;
import org.apache.shenyu.client.grpc.json.JsonServerServiceInterceptor;
import org.apache.shenyu.common.exception.ShenyuException;
import org.apache.shenyu.common.utils.ReflectUtils;
import org.apache.shenyu.protocol.grpc.message.JsonMessage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JsonServerCallListener<R, P>
extends ForwardingServerCallListener<R> {
    private static final Logger LOG = LoggerFactory.getLogger(JsonServerCallListener.class);
    private final ServerCall.Listener<R> delegate;
    private final ServerCall<R, P> call;

    public JsonServerCallListener(ServerCall.Listener<R> delegate, ServerCall<R, P> call) {
        this.delegate = delegate;
        this.call = call;
    }

    protected ServerCall.Listener<R> delegate() {
        return this.delegate;
    }

    public void onMessage(R message) {
        Class<?> t = JsonServerServiceInterceptor.getRequestClazzMap().get(this.call.getMethodDescriptor().getFullMethodName());
        try {
            Message.Builder builder = (Message.Builder)ReflectUtils.invokeStaticMethod(t, (String)"newBuilder");
            String reqData = JsonMessage.getDataFromDynamicMessage((DynamicMessage)((DynamicMessage)message));
            JsonFormat.parser().ignoringUnknownFields().merge(reqData, builder);
            if (Objects.isNull(builder)) {
                throw new ShenyuException("build json response message is error, newBuilder method is null");
            }
            this.delegate.onMessage((Object)builder.build());
        }
        catch (Exception e) {
            throw Status.INTERNAL.withDescription(e.getMessage()).asRuntimeException();
        }
    }

    public void onHalfClose() {
        super.onHalfClose();
    }

    public void onCancel() {
        super.onCancel();
    }

    public void onComplete() {
        super.onComplete();
    }

    public void onReady() {
        super.onReady();
    }
}

