/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.client.apache.dubbo.validation;

import jakarta.validation.Constraint;
import jakarta.validation.ConstraintViolation;
import jakarta.validation.Validation;
import jakarta.validation.ValidationException;
import jakarta.validation.ValidatorFactory;
import jakarta.validation.groups.Default;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import javassist.ClassPool;
import javassist.CtClass;
import javassist.CtField;
import javassist.CtNewConstructor;
import javassist.NotFoundException;
import javassist.bytecode.AnnotationsAttribute;
import javassist.bytecode.AttributeInfo;
import javassist.bytecode.ClassFile;
import javassist.bytecode.ConstPool;
import javassist.bytecode.annotation.Annotation;
import javassist.bytecode.annotation.ArrayMemberValue;
import javassist.bytecode.annotation.BooleanMemberValue;
import javassist.bytecode.annotation.ByteMemberValue;
import javassist.bytecode.annotation.CharMemberValue;
import javassist.bytecode.annotation.ClassMemberValue;
import javassist.bytecode.annotation.DoubleMemberValue;
import javassist.bytecode.annotation.EnumMemberValue;
import javassist.bytecode.annotation.FloatMemberValue;
import javassist.bytecode.annotation.IntegerMemberValue;
import javassist.bytecode.annotation.LongMemberValue;
import javassist.bytecode.annotation.MemberValue;
import javassist.bytecode.annotation.ShortMemberValue;
import javassist.bytecode.annotation.StringMemberValue;
import org.apache.commons.lang3.StringUtils;
import org.apache.dubbo.common.URL;
import org.apache.dubbo.common.bytecode.ClassGenerator;
import org.apache.dubbo.common.utils.ReflectUtils;
import org.apache.dubbo.validation.MethodValidated;
import org.apache.dubbo.validation.Validator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ApacheDubboClientValidator
implements Validator {
    private static final Logger LOG = LoggerFactory.getLogger(ApacheDubboClientValidator.class);
    private final Class<?> clazz;
    private final Map<String, Class<?>> methodClassMap;
    private final jakarta.validation.Validator validator;

    public ApacheDubboClientValidator(URL url) {
        this.clazz = ReflectUtils.forName((String)url.getServiceInterface());
        String shenyuValidation = url.getParameter("shenyuValidation");
        ValidatorFactory factory = StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{shenyuValidation}) ? Validation.byProvider((Class)ReflectUtils.forName((String)shenyuValidation)).configure().buildValidatorFactory() : Validation.buildDefaultValidatorFactory();
        this.validator = factory.getValidator();
        this.methodClassMap = new ConcurrentHashMap();
    }

    private static Object getMethodParameterBean(Class<?> clazz, Method method, Object[] args) {
        if (!ApacheDubboClientValidator.hasConstraintParameter(method)) {
            return null;
        }
        try {
            Class<?> parameterClass;
            String parameterClassName = ApacheDubboClientValidator.generateMethodParameterClassName(clazz, method);
            try {
                parameterClass = Class.forName(parameterClassName, true, clazz.getClassLoader());
            }
            catch (ClassNotFoundException e) {
                parameterClass = ApacheDubboClientValidator.generateMethodParameterClass(clazz, method, parameterClassName);
            }
            Object parameterBean = parameterClass.newInstance();
            for (int i = 0; i < args.length; ++i) {
                Field field = parameterClass.getField(method.getName() + "Argument" + i);
                field.set(parameterBean, args[i]);
            }
            return parameterBean;
        }
        catch (Exception e) {
            LOG.warn(e.getMessage(), (Throwable)e);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Class<?> generateMethodParameterClass(Class<?> clazz, Method method, String parameterClassName) throws Exception {
        ClassPool pool = ClassGenerator.getClassPool((ClassLoader)clazz.getClassLoader());
        String string = parameterClassName.intern();
        synchronized (string) {
            CtClass ctClass = null;
            try {
                ctClass = pool.getCtClass(parameterClassName);
            }
            catch (NotFoundException neglect) {
                LOG.error(neglect.getMessage(), (Throwable)neglect);
            }
            if (Objects.isNull(ctClass)) {
                ctClass = pool.makeClass(parameterClassName);
                ClassFile classFile = ctClass.getClassFile();
                classFile.setVersionToJava5();
                ctClass.addConstructor(CtNewConstructor.defaultConstructor((CtClass)pool.getCtClass(parameterClassName)));
                Class<?>[] parameterTypes = method.getParameterTypes();
                java.lang.annotation.Annotation[][] parameterAnnotations = method.getParameterAnnotations();
                for (int i = 0; i < parameterTypes.length; ++i) {
                    Class<?> type = parameterTypes[i];
                    java.lang.annotation.Annotation[] annotations = parameterAnnotations[i];
                    AnnotationsAttribute attribute = new AnnotationsAttribute(classFile.getConstPool(), "RuntimeVisibleAnnotations");
                    for (java.lang.annotation.Annotation annotation : annotations) {
                        Method[] members;
                        if (!annotation.annotationType().isAnnotationPresent(Constraint.class)) continue;
                        Annotation ja = new Annotation(classFile.getConstPool(), pool.getCtClass(annotation.annotationType().getName()));
                        for (Method member : members = annotation.annotationType().getMethods()) {
                            Object value;
                            if (!Modifier.isPublic(member.getModifiers()) || member.getParameterTypes().length != 0 || member.getDeclaringClass() != annotation.annotationType() || !Objects.nonNull(value = member.invoke((Object)annotation, new Object[0]))) continue;
                            MemberValue memberValue = ApacheDubboClientValidator.createMemberValue(classFile.getConstPool(), pool.get(member.getReturnType().getName()), value);
                            ja.addMemberValue(member.getName(), memberValue);
                        }
                        attribute.addAnnotation(ja);
                    }
                    String fieldName = method.getName() + "Argument" + i;
                    CtField ctField = CtField.make((String)("public " + type.getCanonicalName() + " " + fieldName + ";"), (CtClass)pool.getCtClass(parameterClassName));
                    ctField.getFieldInfo().addAttribute((AttributeInfo)attribute);
                    ctClass.addField(ctField);
                }
                return ctClass.toClass(clazz.getClassLoader(), null);
            }
            return Class.forName(parameterClassName, true, clazz.getClassLoader());
        }
    }

    private static String generateMethodParameterClassName(Class<?> clazz, Method method) {
        Class<?>[] parameterTypes;
        StringBuilder builder = new StringBuilder().append(clazz.getName()).append("_").append(ApacheDubboClientValidator.toUpperMethoName(method.getName())).append("Parameter");
        for (Class<?> parameterType : parameterTypes = method.getParameterTypes()) {
            builder.append("_").append(parameterType.getName());
        }
        return builder.toString();
    }

    private static boolean hasConstraintParameter(Method method) {
        java.lang.annotation.Annotation[][] parameterAnnotations;
        java.lang.annotation.Annotation[][] annotationArray = parameterAnnotations = method.getParameterAnnotations();
        int n = annotationArray.length;
        for (int i = 0; i < n; ++i) {
            java.lang.annotation.Annotation[] annotations;
            for (java.lang.annotation.Annotation annotation : annotations = annotationArray[i]) {
                if (!annotation.annotationType().isAnnotationPresent(Constraint.class)) continue;
                return true;
            }
        }
        return false;
    }

    private static String toUpperMethoName(String methodName) {
        return methodName.substring(0, 1).toUpperCase() + methodName.substring(1);
    }

    private static MemberValue createMemberValue(ConstPool cp, CtClass type, Object value) throws NotFoundException {
        MemberValue memberValue = Annotation.createMemberValue((ConstPool)cp, (CtClass)type);
        if (memberValue instanceof BooleanMemberValue) {
            ((BooleanMemberValue)memberValue).setValue(((Boolean)value).booleanValue());
        } else if (memberValue instanceof ByteMemberValue) {
            ((ByteMemberValue)memberValue).setValue(((Byte)value).byteValue());
        } else if (memberValue instanceof CharMemberValue) {
            ((CharMemberValue)memberValue).setValue(((Character)value).charValue());
        } else if (memberValue instanceof ShortMemberValue) {
            ((ShortMemberValue)memberValue).setValue(((Short)value).shortValue());
        } else if (memberValue instanceof IntegerMemberValue) {
            ((IntegerMemberValue)memberValue).setValue(((Integer)value).intValue());
        } else if (memberValue instanceof LongMemberValue) {
            ((LongMemberValue)memberValue).setValue(((Long)value).longValue());
        } else if (memberValue instanceof FloatMemberValue) {
            ((FloatMemberValue)memberValue).setValue(((Float)value).floatValue());
        } else if (memberValue instanceof DoubleMemberValue) {
            ((DoubleMemberValue)memberValue).setValue(((Double)value).doubleValue());
        } else if (memberValue instanceof ClassMemberValue) {
            ((ClassMemberValue)memberValue).setValue(((Class)value).getName());
        } else if (memberValue instanceof StringMemberValue) {
            ((StringMemberValue)memberValue).setValue((String)value);
        } else if (memberValue instanceof EnumMemberValue) {
            ((EnumMemberValue)memberValue).setValue(((Enum)value).name());
        } else if (memberValue instanceof ArrayMemberValue) {
            CtClass arrayType = type.getComponentType();
            int len = Array.getLength(value);
            MemberValue[] members = new MemberValue[len];
            for (int i = 0; i < len; ++i) {
                members[i] = ApacheDubboClientValidator.createMemberValue(cp, arrayType, Array.get(value, i));
            }
            ((ArrayMemberValue)memberValue).setValue(members);
        }
        return memberValue;
    }

    public void validate(String methodName, Class<?>[] parameterTypes, Object[] arguments) throws Exception {
        ArrayList groups = new ArrayList();
        Class<?> methodClass = this.methodClass(methodName);
        if (Objects.nonNull(methodClass)) {
            groups.add(methodClass);
        }
        HashSet violations = new HashSet();
        Method method = this.clazz.getMethod(methodName, parameterTypes);
        if (method.isAnnotationPresent(MethodValidated.class)) {
            Class[] methodClasses = method.getAnnotation(MethodValidated.class).value();
            groups.addAll(Arrays.asList(methodClasses));
        }
        groups.add(0, Default.class);
        groups.add(1, this.clazz);
        Class[] classGroups = new Class[groups.size()];
        classGroups = groups.toArray(classGroups);
        Object parameterBean = ApacheDubboClientValidator.getMethodParameterBean(this.clazz, method, arguments);
        if (Objects.nonNull(parameterBean)) {
            violations.addAll(this.validator.validate(parameterBean, classGroups));
        }
        for (Object arg : arguments) {
            this.validate(violations, arg, classGroups);
        }
        if (!violations.isEmpty()) {
            LOG.error("Failed to validate service: {}, method: {}, cause: {}", new Object[]{this.clazz.getName(), methodName, violations});
            StringBuilder validateError = new StringBuilder();
            violations.forEach(each -> validateError.append(each.getMessage()).append(","));
            throw new ValidationException(validateError.substring(0, validateError.length() - 1));
        }
    }

    private void validate(Set<ConstraintViolation<?>> violations, Object arg, Class<?> ... groups) {
        if (Objects.nonNull(arg) && !ReflectUtils.isPrimitives(arg.getClass())) {
            if (arg instanceof Object[]) {
                for (Object item : (Object[])arg) {
                    this.validate(violations, item, groups);
                }
            } else if (arg instanceof Collection) {
                for (Object item : (Collection)arg) {
                    this.validate(violations, item, groups);
                }
            } else if (arg instanceof Map) {
                for (Map.Entry entry : ((Map)arg).entrySet()) {
                    this.validate(violations, entry.getKey(), groups);
                    this.validate(violations, entry.getValue(), groups);
                }
            } else {
                violations.addAll(this.validator.validate(arg, (Class[])groups));
            }
        }
    }

    private Class<?> methodClass(String methodName) {
        Class<?> methodClass = null;
        String methodClassName = this.clazz.getName() + "$" + ApacheDubboClientValidator.toUpperMethoName(methodName);
        Class<?> cached = this.methodClassMap.get(methodClassName);
        if (Objects.nonNull(cached)) {
            return cached == this.clazz ? null : cached;
        }
        try {
            methodClass = Class.forName(methodClassName, false, Thread.currentThread().getContextClassLoader());
            this.methodClassMap.put(methodClassName, methodClass);
        }
        catch (ClassNotFoundException e) {
            this.methodClassMap.put(methodClassName, this.clazz);
        }
        return methodClass;
    }
}

