/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.client.apache.dubbo.processor.extractor;

import java.util.List;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;
import org.apache.dubbo.config.annotation.DubboService;
import org.apache.dubbo.config.spring.ServiceBean;
import org.apache.shenyu.client.core.register.ApiBean;
import org.apache.shenyu.client.core.register.matcher.ApiAnnotationProcessor;
import org.apache.shenyu.client.core.register.matcher.ExtractorProcessor;
import org.apache.shenyu.client.dubbo.common.dto.DubboRpcExt;
import org.apache.shenyu.common.enums.RpcTypeEnum;
import org.apache.shenyu.common.utils.GsonUtils;
import org.apache.shenyu.common.utils.ListUtil;

public class DubboServiceProcessor
implements ApiAnnotationProcessor<DubboService>,
ExtractorProcessor {
    public List<String> supportedClient() {
        return ListUtil.of((Object[])new String[]{RpcTypeEnum.DUBBO.getName()});
    }

    public void process(ApiBean apiBean, DubboService annotation) {
        apiBean.setBeanPath(annotation.path());
        apiBean.addProperties("rpcExt", this.getRpcExt(apiBean));
    }

    public void process(ApiBean.ApiDefinition definition) {
        definition.addProperties("rpcExt", this.getRpcExt(definition));
    }

    public void process(ApiBean.ApiDefinition definition, DubboService annotation) {
    }

    public Class<DubboService> matchAnnotation() {
        return DubboService.class;
    }

    private String getRpcExt(ApiBean apiBean) {
        Object beanInstance = apiBean.getBeanInstance();
        if (beanInstance instanceof ServiceBean) {
            return DubboServiceProcessor.getRpcExt((ServiceBean)beanInstance);
        }
        return "{}";
    }

    private String getRpcExt(ApiBean.ApiDefinition definition) {
        Object beanInstance = definition.getApiBean().getBeanInstance();
        if (beanInstance instanceof ServiceBean) {
            return DubboServiceProcessor.getRpcExt((ServiceBean)beanInstance);
        }
        return "{}";
    }

    private static String getRpcExt(ServiceBean<?> serviceBean) {
        DubboRpcExt build = DubboRpcExt.builder().protocol(StringUtils.isNotEmpty((CharSequence)serviceBean.getProtocol().getName()) ? serviceBean.getProtocol().getName() : "").group(StringUtils.isNotEmpty((CharSequence)serviceBean.getGroup()) ? serviceBean.getGroup() : "").version(StringUtils.isNotEmpty((CharSequence)serviceBean.getVersion()) ? serviceBean.getVersion() : "").loadbalance(StringUtils.isNotEmpty((CharSequence)serviceBean.getLoadbalance()) ? serviceBean.getLoadbalance() : "random").retries(Optional.ofNullable(serviceBean.getRetries()).orElse(2)).timeout(Optional.ofNullable(serviceBean.getTimeout()).orElse(3000)).sent(Optional.ofNullable(serviceBean.getSent()).orElse(Boolean.FALSE)).cluster(StringUtils.isNotEmpty((CharSequence)serviceBean.getCluster()) ? serviceBean.getCluster() : "failover").url("").build();
        return GsonUtils.getInstance().toJson((Object)build);
    }
}

