/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.admin.scale.collector;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.util.Objects;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.Response;
import org.apache.shenyu.admin.config.properties.DeploymentProperties;
import org.apache.shenyu.admin.scale.collector.provider.MetricData;
import org.apache.shenyu.admin.scale.collector.provider.MetricsProvider;
import org.apache.shenyu.admin.scale.config.PrometheusProperties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class PrometheusMetricsProvider
implements MetricsProvider {
    private static final Logger LOG = LoggerFactory.getLogger(PrometheusMetricsProvider.class);
    private final PrometheusProperties prometheusProperties;
    private final DeploymentProperties deploymentProperties;
    private final OkHttpClient httpClient;
    private final ObjectMapper objectMapper;

    public PrometheusMetricsProvider(PrometheusProperties prometheusProperties, DeploymentProperties deploymentProperties) {
        this.prometheusProperties = prometheusProperties;
        this.deploymentProperties = deploymentProperties;
        this.httpClient = new OkHttpClient();
        this.objectMapper = new ObjectMapper();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public MetricData getMetricData(String metricName) {
        String queryTemplate = this.prometheusProperties.getQueries().get(metricName);
        if (Objects.isNull(queryTemplate)) {
            LOG.error("No query template found for metric: {}", (Object)metricName);
            return null;
        }
        String query = String.format(queryTemplate, this.deploymentProperties.getNamespace(), this.deploymentProperties.getName());
        String queryUrl = String.format("%s/api/v1/query?query=%s", this.prometheusProperties.getUrl(), query);
        Request request = new Request.Builder().url(queryUrl).get().build();
        try (Response response = this.httpClient.newCall(request).execute();){
            if (!response.isSuccessful()) {
                LOG.error("Failed to fetch metrics from Prometheus: {}", (Object)response.message());
                MetricData metricData = null;
                return metricData;
            }
            if (Objects.isNull(response.body())) {
                LOG.error("Response body is null for metric: {}", (Object)metricName);
                MetricData metricData = null;
                return metricData;
            }
            JsonNode jsonNode = this.objectMapper.readTree(response.body().string());
            MetricData metricData = this.parseMetricData(metricName, jsonNode);
            return metricData;
        }
        catch (IOException e) {
            LOG.error("Failed to get metric data. cause: {} ", (Object)e.getMessage());
            return null;
        }
    }

    private MetricData parseMetricData(String metricName, JsonNode jsonNode) {
        JsonNode statusNode = jsonNode.get("status");
        if (Objects.isNull(statusNode) || !"success".equals(statusNode.asText())) {
            LOG.error("Failed to fetch metric: {} ", (Object)metricName);
            return null;
        }
        JsonNode dataNode = jsonNode.get("data").get("result");
        if (dataNode.isEmpty()) {
            LOG.error("No data found for metric: {} ", (Object)metricName);
            return null;
        }
        JsonNode valueNode = dataNode.get(0).get("value");
        if (Objects.isNull(valueNode) || valueNode.size() < 2) {
            LOG.error("Invalid metric data format for: {} ", (Object)metricName);
            return null;
        }
        try {
            double value = Double.parseDouble(valueNode.get(1).asText());
            return new MetricData(metricName, value);
        }
        catch (NumberFormatException e) {
            LOG.error("Failed to parse metric value for: {} ", (Object)metricName);
            return null;
        }
    }
}

