/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.admin.controller;

import jakarta.validation.Valid;
import jakarta.validation.constraints.NotBlank;
import jakarta.validation.constraints.NotNull;
import java.util.List;
import org.apache.shenyu.admin.aspect.annotation.RestApi;
import org.apache.shenyu.admin.mapper.NamespaceMapper;
import org.apache.shenyu.admin.model.dto.NamespaceDTO;
import org.apache.shenyu.admin.model.page.CommonPager;
import org.apache.shenyu.admin.model.page.PageParameter;
import org.apache.shenyu.admin.model.query.NamespaceQuery;
import org.apache.shenyu.admin.model.result.ShenyuAdminResult;
import org.apache.shenyu.admin.model.vo.NamespaceVO;
import org.apache.shenyu.admin.service.NamespaceService;
import org.apache.shenyu.admin.validation.annotation.Existed;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;

@RestApi(value={"/namespace"})
public class NamespaceController {
    private final NamespaceService namespaceService;

    public NamespaceController(NamespaceService namespaceService) {
        this.namespaceService = namespaceService;
    }

    @GetMapping(value={"/findPageByQuery"})
    @RequiresPermissions(value={"system:namespace:list"})
    public ShenyuAdminResult findPageByQuery(String namespaceId, String name, @RequestParam @NotNull(message="currentPage not null") @NotNull(message="currentPage not null") Integer currentPage, @RequestParam @NotNull(message="pageSize not null") @NotNull(message="pageSize not null") Integer pageSize) {
        NamespaceQuery query = new NamespaceQuery();
        query.setNamespaceId(namespaceId);
        query.setName(name);
        query.setPageParameter(new PageParameter(currentPage, pageSize));
        CommonPager<NamespaceVO> commonPager = this.namespaceService.listByPage(query);
        return ShenyuAdminResult.success("query success", commonPager);
    }

    @GetMapping(value={"/list"})
    @RequiresPermissions(value={"system:namespace:list"})
    public ShenyuAdminResult list(String name) {
        return ShenyuAdminResult.success("query success", this.namespaceService.list(name));
    }

    @PostMapping(value={"/insertOrUpdate"})
    public ShenyuAdminResult createOrUpdate(@Valid @RequestBody NamespaceDTO namespaceDTO) {
        return ShenyuAdminResult.success("success", this.namespaceService.createOrUpdate(namespaceDTO));
    }

    @DeleteMapping(value={"/batch"})
    public ShenyuAdminResult delete(@RequestBody List<@NotBlank String> ids) {
        return ShenyuAdminResult.success("success", this.namespaceService.delete(ids));
    }

    @GetMapping(value={"/{id}"})
    @RequiresPermissions(value={"system:namespace:edit"})
    public ShenyuAdminResult detailPlugin(@PathVariable(value="id") @Existed(message="namespaceId is not existed", provider=NamespaceMapper.class) @Existed(message="namespaceId is not existed", provider=NamespaceMapper.class) String namespaceId) {
        NamespaceVO namespaceVO = this.namespaceService.findByNamespaceId(namespaceId);
        return ShenyuAdminResult.success("detail success", namespaceVO);
    }
}

