/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.admin.service.impl;

import java.sql.Timestamp;
import java.time.Instant;
import java.util.List;
import java.util.Objects;
import org.apache.shenyu.admin.mapper.InstanceInfoMapper;
import org.apache.shenyu.admin.model.dto.InstanceInfoDTO;
import org.apache.shenyu.admin.model.entity.InstanceInfoDO;
import org.apache.shenyu.admin.model.page.CommonPager;
import org.apache.shenyu.admin.model.page.PageResultUtils;
import org.apache.shenyu.admin.model.query.InstanceQuery;
import org.apache.shenyu.admin.model.vo.InstanceInfoVO;
import org.apache.shenyu.admin.service.InstanceInfoService;
import org.apache.shenyu.common.utils.GsonUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class InstanceInfoServiceImpl
implements InstanceInfoService {
    private static final Logger LOG = LoggerFactory.getLogger(InstanceInfoServiceImpl.class);
    private final InstanceInfoMapper instanceInfoMapper;

    public InstanceInfoServiceImpl(InstanceInfoMapper instanceInfoMapper) {
        this.instanceInfoMapper = instanceInfoMapper;
    }

    @Override
    public void createOrUpdate(InstanceInfoDTO instanceInfoDTO) {
        InstanceQuery instanceQuery = new InstanceQuery();
        instanceQuery.setInstanceIp(instanceInfoDTO.getInstanceIp());
        instanceQuery.setInstancePort(instanceInfoDTO.getInstancePort());
        instanceQuery.setInstanceType(instanceInfoDTO.getInstanceType());
        instanceQuery.setNamespaceId(instanceInfoDTO.getNamespaceId());
        InstanceInfoDO infoDO = this.instanceInfoMapper.selectOneByQuery(instanceQuery);
        if (Objects.isNull(infoDO)) {
            LOG.info("Register new instance info: {}", (Object)GsonUtils.getInstance().toJson((Object)instanceInfoDTO));
            InstanceInfoDO instanceInfoDO = InstanceInfoDO.buildInstanceInfoDO(instanceInfoDTO);
            try {
                this.instanceInfoMapper.insert(instanceInfoDO);
            }
            catch (Exception e) {
                LOG.error("Failed to register instance info", (Throwable)e);
            }
            return;
        }
        LOG.info("Update instance info: {}", (Object)GsonUtils.getInstance().toJson((Object)instanceInfoDTO));
        infoDO.setInstanceIp(instanceInfoDTO.getInstanceIp());
        infoDO.setInstanceType(instanceInfoDTO.getInstanceType());
        infoDO.setInstanceInfo(instanceInfoDTO.getInstanceInfo());
        infoDO.setNamespaceId(instanceInfoDTO.getNamespaceId());
        infoDO.setDateUpdated(Timestamp.from(Instant.now()));
        infoDO.setInstanceState(instanceInfoDTO.getInstanceState());
        this.instanceInfoMapper.updateById(infoDO);
    }

    @Override
    public CommonPager<InstanceInfoVO> listByPage(InstanceQuery instanceQuery) {
        List<InstanceInfoDO> instanceInfoDOList = this.instanceInfoMapper.selectByQuery(instanceQuery);
        return PageResultUtils.result(instanceQuery.getPageParameter(), () -> this.buildInstanceInfoVO(instanceInfoDOList));
    }

    @Override
    public InstanceInfoVO findById(String id) {
        return null;
    }

    private List<InstanceInfoVO> buildInstanceInfoVO(List<InstanceInfoDO> instanceInfoDOList) {
        if (instanceInfoDOList.isEmpty()) {
            return List.of();
        }
        return instanceInfoDOList.stream().map(this::buildInstanceInfoVO).toList();
    }

    private InstanceInfoVO buildInstanceInfoVO(InstanceInfoDO instanceInfoDO) {
        InstanceInfoVO instanceInfoVO = new InstanceInfoVO();
        instanceInfoVO.setInstanceIp(instanceInfoDO.getInstanceIp());
        instanceInfoVO.setInstancePort(instanceInfoDO.getInstancePort());
        instanceInfoVO.setInstanceType(instanceInfoDO.getInstanceType());
        instanceInfoVO.setInstanceInfo(instanceInfoDO.getInstanceInfo());
        instanceInfoVO.setNamespaceId(instanceInfoDO.getNamespaceId());
        instanceInfoVO.setDateCreated(instanceInfoDO.getDateCreated());
        instanceInfoVO.setDateUpdated(instanceInfoDO.getDateUpdated());
        return instanceInfoVO;
    }
}

