/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.admin.transfer;

import java.time.LocalDateTime;
import java.util.Optional;
import org.apache.shenyu.admin.model.dto.AppAuthDTO;
import org.apache.shenyu.admin.model.entity.AppAuthDO;
import org.apache.shenyu.admin.model.entity.AuthParamDO;
import org.apache.shenyu.admin.model.entity.AuthPathDO;
import org.apache.shenyu.admin.model.vo.AppAuthVO;
import org.apache.shenyu.admin.model.vo.AuthParamVO;
import org.apache.shenyu.admin.model.vo.AuthPathVO;
import org.apache.shenyu.common.utils.DateUtils;

public enum AppAuthTransfer {
    INSTANCE;


    public AppAuthDO mapToEntity(AppAuthDTO appAuthDTO) {
        return Optional.ofNullable(appAuthDTO).map(v -> {
            AppAuthDO.AppAuthDOBuilder appAuthDO = AppAuthDO.builder();
            appAuthDO.id(v.getId());
            appAuthDO.appKey(v.getAppKey());
            appAuthDO.appSecret(v.getAppSecret());
            appAuthDO.enabled(v.getEnabled());
            appAuthDO.open(v.getOpen());
            appAuthDO.userId(v.getUserId());
            appAuthDO.phone(v.getPhone());
            appAuthDO.extInfo(v.getExtInfo());
            appAuthDO.namespaceId(v.getNamespaceId());
            return appAuthDO.build();
        }).orElse(null);
    }

    public AppAuthVO mapToVO(AppAuthDO appAuthDO) {
        return Optional.ofNullable(appAuthDO).map(v -> {
            AppAuthVO appAuthVO = new AppAuthVO();
            appAuthVO.setId(v.getId());
            appAuthVO.setAppKey(v.getAppKey());
            appAuthVO.setAppSecret(v.getAppSecret());
            appAuthVO.setUserId(v.getUserId());
            appAuthVO.setPhone(v.getPhone());
            appAuthVO.setExtInfo(v.getExtInfo());
            appAuthVO.setOpen(v.getOpen());
            appAuthVO.setEnabled(appAuthDO.getEnabled());
            appAuthVO.setNamespaceId(appAuthDO.getNamespaceId());
            appAuthVO.setDateUpdated(Optional.ofNullable(appAuthDO.getDateUpdated()).map(u -> DateUtils.localDateTimeToString((LocalDateTime)u.toLocalDateTime())).orElse(null));
            return appAuthVO;
        }).orElse(null);
    }

    public AuthParamVO mapToVO(AuthParamDO authParamDO) {
        return Optional.ofNullable(authParamDO).map(v -> {
            AuthParamVO authParamVO = new AuthParamVO();
            authParamVO.setAppName(v.getAppName());
            authParamVO.setAppParam(v.getAppParam());
            return authParamVO;
        }).orElse(null);
    }

    public AuthPathVO mapToVO(AuthPathDO authPathDO) {
        return Optional.ofNullable(authPathDO).map(v -> {
            AuthPathVO authPathVO = new AuthPathVO();
            authPathVO.setId(v.getId());
            authPathVO.setAppName(v.getAppName());
            authPathVO.setPath(v.getPath());
            authPathVO.setEnabled(v.getEnabled());
            return authPathVO;
        }).orElse(null);
    }
}

