/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.admin.model.entity;

import java.sql.Timestamp;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;
import org.apache.shenyu.admin.model.dto.SelectorDTO;
import org.apache.shenyu.admin.model.entity.BaseDO;
import org.apache.shenyu.common.dto.ConditionData;
import org.apache.shenyu.common.dto.SelectorData;
import org.apache.shenyu.common.enums.MatchModeEnum;
import org.apache.shenyu.common.enums.SelectorTypeEnum;
import org.apache.shenyu.common.utils.UUIDUtils;

public final class SelectorDO
extends BaseDO {
    private static final long serialVersionUID = -1627940797162331235L;
    private String pluginId;
    private String name;
    private Integer matchMode;
    private Integer type;
    private Integer sort;
    private Boolean enabled;
    private Boolean loged;
    private Boolean continued;
    private String handle;
    private Boolean matchRestful;
    private String namespaceId;

    public SelectorDO() {
    }

    public SelectorDO(String pluginId, String name, Integer matchMode, Integer type, Integer sort, Boolean enabled, Boolean loged, Boolean continued, String handle, Boolean matchRestful, String namespaceId) {
        this.pluginId = pluginId;
        this.name = name;
        this.matchMode = matchMode;
        this.type = type;
        this.sort = sort;
        this.enabled = enabled;
        this.loged = loged;
        this.continued = continued;
        this.handle = handle;
        this.matchRestful = matchRestful;
        this.namespaceId = namespaceId;
    }

    public String getPluginId() {
        return this.pluginId;
    }

    public void setPluginId(String pluginId) {
        this.pluginId = pluginId;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Integer getMatchMode() {
        return this.matchMode;
    }

    public void setMatchMode(Integer matchMode) {
        this.matchMode = matchMode;
    }

    public Integer getType() {
        return this.type;
    }

    public void setType(Integer type) {
        this.type = type;
    }

    public Integer getSort() {
        return this.sort;
    }

    public void setSort(Integer sort) {
        this.sort = sort;
    }

    public Boolean getEnabled() {
        return this.enabled;
    }

    public void setEnabled(Boolean enabled) {
        this.enabled = enabled;
    }

    public Boolean getLoged() {
        return this.loged;
    }

    public void setLoged(Boolean loged) {
        this.loged = loged;
    }

    public Boolean getContinued() {
        return this.continued;
    }

    public void setContinued(Boolean continued) {
        this.continued = continued;
    }

    public String getHandle() {
        return this.handle;
    }

    public void setHandle(String handle) {
        this.handle = handle;
    }

    public Boolean getMatchRestful() {
        return this.matchRestful;
    }

    public void setMatchRestful(Boolean matchRestful) {
        this.matchRestful = matchRestful;
    }

    public String getNamespaceId() {
        return this.namespaceId;
    }

    public void setNamespaceId(String namespaceId) {
        this.namespaceId = namespaceId;
    }

    public static SelectorDOBuilder builder() {
        return new SelectorDOBuilder();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (Objects.isNull(o) || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        SelectorDO that = (SelectorDO)o;
        return Objects.equals(this.pluginId, that.pluginId) && Objects.equals(this.name, that.name) && Objects.equals(this.matchMode, that.matchMode) && Objects.equals(this.type, that.type) && Objects.equals(this.sort, that.sort) && Objects.equals(this.enabled, that.enabled) && Objects.equals(this.loged, that.loged) && Objects.equals(this.continued, that.continued) && Objects.equals(this.handle, that.handle) && Objects.equals(this.matchRestful, that.matchRestful) && Objects.equals(this.namespaceId, that.namespaceId);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.pluginId, this.name, this.matchMode, this.type, this.sort, this.enabled, this.loged, this.continued, this.handle, this.matchRestful, this.namespaceId);
    }

    public static SelectorDO buildSelectorDO(SelectorDTO selectorDTO) {
        return Optional.ofNullable(selectorDTO).map(item -> {
            Timestamp currentTime = new Timestamp(System.currentTimeMillis());
            SelectorDO selectorDO = SelectorDO.builder().type(item.getType()).sort(item.getSort()).enabled(item.getEnabled()).loged(item.getLoged()).continued(item.getContinued()).dateUpdated(currentTime).handle(item.getHandle()).pluginId(item.getPluginId()).name(item.getName()).matchRestful(item.getMatchRestful()).namespaceId(item.getNamespaceId()).build();
            if (StringUtils.isEmpty((CharSequence)item.getId())) {
                selectorDO.setId(UUIDUtils.getInstance().generateShortUuid());
                selectorDO.setDateCreated(currentTime);
            } else {
                selectorDO.setId(item.getId());
            }
            if (SelectorTypeEnum.FULL_FLOW.getCode() == item.getType().intValue()) {
                selectorDO.setMatchMode(MatchModeEnum.AND.getCode());
            } else {
                selectorDO.setMatchMode(item.getMatchMode());
            }
            return selectorDO;
        }).orElse(null);
    }

    public static SelectorData transFrom(SelectorDO selectorDO, String pluginName, List<ConditionData> conditionDataList, List<ConditionData> beforeConditionDataList) {
        return SelectorData.builder().id(selectorDO.getId()).pluginId(selectorDO.getPluginId()).pluginName(pluginName).name(selectorDO.getName()).matchMode(selectorDO.getMatchMode()).type(selectorDO.getType()).sort(selectorDO.getSort()).enabled(selectorDO.getEnabled()).logged(selectorDO.getLoged()).continued(selectorDO.getContinued()).handle(selectorDO.getHandle()).conditionList(conditionDataList).matchRestful(selectorDO.getMatchRestful()).beforeConditionList(beforeConditionDataList).namespaceId(selectorDO.getNamespaceId()).build();
    }

    public static SelectorData transFrom(SelectorDO selectorDO, String pluginName, List<ConditionData> conditionDataList) {
        return SelectorDO.transFrom(selectorDO, pluginName, conditionDataList, Collections.emptyList());
    }

    public static final class SelectorDOBuilder {
        private String id;
        private Timestamp dateCreated;
        private Timestamp dateUpdated;
        private String pluginId;
        private String name;
        private Integer matchMode;
        private Integer type;
        private Integer sort;
        private Boolean enabled;
        private Boolean loged;
        private Boolean continued;
        private String handle;
        private Boolean matchRestful;
        private String namespaceId;

        private SelectorDOBuilder() {
        }

        public SelectorDOBuilder id(String id) {
            this.id = id;
            return this;
        }

        public SelectorDOBuilder dateCreated(Timestamp dateCreated) {
            this.dateCreated = dateCreated;
            return this;
        }

        public SelectorDOBuilder dateUpdated(Timestamp dateUpdated) {
            this.dateUpdated = dateUpdated;
            return this;
        }

        public SelectorDOBuilder pluginId(String pluginId) {
            this.pluginId = pluginId;
            return this;
        }

        public SelectorDOBuilder name(String name) {
            this.name = name;
            return this;
        }

        public SelectorDOBuilder matchMode(Integer matchMode) {
            this.matchMode = matchMode;
            return this;
        }

        public SelectorDOBuilder type(Integer type) {
            this.type = type;
            return this;
        }

        public SelectorDOBuilder sort(Integer sort) {
            this.sort = sort;
            return this;
        }

        public SelectorDOBuilder enabled(Boolean enabled) {
            this.enabled = enabled;
            return this;
        }

        public SelectorDOBuilder loged(Boolean loged) {
            this.loged = loged;
            return this;
        }

        public SelectorDOBuilder continued(Boolean continued) {
            this.continued = continued;
            return this;
        }

        public SelectorDOBuilder handle(String handle) {
            this.handle = handle;
            return this;
        }

        public SelectorDOBuilder matchRestful(Boolean matchRestful) {
            this.matchRestful = matchRestful;
            return this;
        }

        public SelectorDOBuilder namespaceId(String namespaceId) {
            this.namespaceId = namespaceId;
            return this;
        }

        public SelectorDO build() {
            SelectorDO selectorDO = new SelectorDO();
            selectorDO.setId(this.id);
            selectorDO.setDateCreated(this.dateCreated);
            selectorDO.setDateUpdated(this.dateUpdated);
            selectorDO.setPluginId(this.pluginId);
            selectorDO.setName(this.name);
            selectorDO.setMatchMode(this.matchMode);
            selectorDO.setType(this.type);
            selectorDO.setSort(this.sort);
            selectorDO.setEnabled(this.enabled);
            selectorDO.setLoged(this.loged);
            selectorDO.setContinued(this.continued);
            selectorDO.setHandle(this.handle);
            selectorDO.setMatchRestful(this.matchRestful);
            selectorDO.setNamespaceId(this.namespaceId);
            return selectorDO;
        }
    }
}

