/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.admin.disruptor;

import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.shenyu.admin.disruptor.executor.RegisterServerConsumerExecutor;
import org.apache.shenyu.admin.disruptor.subscriber.ApiDocExecutorSubscriber;
import org.apache.shenyu.admin.disruptor.subscriber.DiscoveryConfigRegisterExecutorSubscriber;
import org.apache.shenyu.admin.disruptor.subscriber.MetadataExecutorSubscriber;
import org.apache.shenyu.admin.disruptor.subscriber.URIRegisterExecutorSubscriber;
import org.apache.shenyu.admin.register.ShenyuClientServerRegisterPublisher;
import org.apache.shenyu.admin.service.DiscoveryService;
import org.apache.shenyu.admin.service.register.ShenyuClientRegisterService;
import org.apache.shenyu.disruptor.DisruptorProviderManage;
import org.apache.shenyu.disruptor.consumer.QueueConsumerFactory;
import org.apache.shenyu.disruptor.provider.DisruptorProvider;
import org.apache.shenyu.register.common.type.DataTypeParent;

public class RegisterClientServerDisruptorPublisher
implements ShenyuClientServerRegisterPublisher {
    private static final RegisterClientServerDisruptorPublisher INSTANCE = new RegisterClientServerDisruptorPublisher();
    private DisruptorProviderManage<Collection<DataTypeParent>> providerManage;

    public static RegisterClientServerDisruptorPublisher getInstance() {
        return INSTANCE;
    }

    public void start(Map<String, ShenyuClientRegisterService> shenyuClientRegisterService, DiscoveryService discoveryService) {
        RegisterServerConsumerExecutor.RegisterServerExecutorFactory factory = new RegisterServerConsumerExecutor.RegisterServerExecutorFactory();
        factory.addSubscribers(new URIRegisterExecutorSubscriber(shenyuClientRegisterService));
        factory.addSubscribers(new MetadataExecutorSubscriber(shenyuClientRegisterService));
        factory.addSubscribers(new ApiDocExecutorSubscriber(shenyuClientRegisterService));
        factory.addSubscribers(new DiscoveryConfigRegisterExecutorSubscriber(discoveryService));
        this.providerManage = new DisruptorProviderManage((QueueConsumerFactory)factory);
        this.providerManage.startup();
    }

    @Override
    public void publish(DataTypeParent data) {
        DisruptorProvider provider = this.providerManage.getProvider();
        provider.onData(Collections.singleton(data));
    }

    @Override
    public void publish(Collection<? extends DataTypeParent> dataList) {
        DisruptorProvider provider = this.providerManage.getProvider();
        provider.onData((Object)dataList.stream().map(DataTypeParent.class::cast).collect(Collectors.toList()));
    }

    @Override
    public void close() {
        this.providerManage.getProvider().shutdown();
    }
}

