/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.infra.database.sql92.connector;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.shardingsphere.infra.database.core.connector.ConnectionProperties;
import org.apache.shardingsphere.infra.database.core.connector.ConnectionPropertiesParser;
import org.apache.shardingsphere.infra.database.core.connector.StandardConnectionProperties;
import org.apache.shardingsphere.infra.database.core.connector.url.UnrecognizedDatabaseURLException;
import org.apache.shardingsphere.infra.exception.core.ShardingSpherePreconditions;

public final class SQL92ConnectionPropertiesParser
implements ConnectionPropertiesParser {
    private static final int DEFAULT_PORT = -1;
    private static final Pattern URL_PATTERN = Pattern.compile("jdbc:.*", 2);

    public ConnectionProperties parse(String url, String username, String catalog) {
        Matcher matcher = URL_PATTERN.matcher(url);
        ShardingSpherePreconditions.checkState((boolean)matcher.find(), () -> new UnrecognizedDatabaseURLException(url, URL_PATTERN.pattern()));
        return new StandardConnectionProperties("", -1, "", null);
    }

    public String getDatabaseType() {
        return "SQL92";
    }
}

