/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.data.pipeline.api.datasource.config.impl;

import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import lombok.Generated;
import org.apache.shardingsphere.data.pipeline.api.datasource.config.PipelineDataSourceConfiguration;
import org.apache.shardingsphere.data.pipeline.api.datasource.config.yaml.YamlJdbcConfiguration;
import org.apache.shardingsphere.data.pipeline.spi.datasource.JdbcQueryPropertiesExtension;
import org.apache.shardingsphere.infra.database.core.connector.url.JdbcUrlAppender;
import org.apache.shardingsphere.infra.database.core.connector.url.StandardJdbcUrlParser;
import org.apache.shardingsphere.infra.database.core.spi.DatabaseTypedSPILoader;
import org.apache.shardingsphere.infra.database.core.type.DatabaseType;
import org.apache.shardingsphere.infra.database.core.type.DatabaseTypeFactory;
import org.apache.shardingsphere.infra.datasource.pool.props.domain.DataSourcePoolProperties;
import org.apache.shardingsphere.infra.util.yaml.YamlEngine;
import org.apache.shardingsphere.infra.yaml.config.swapper.resource.YamlDataSourceConfigurationSwapper;

public final class StandardPipelineDataSourceConfiguration
implements PipelineDataSourceConfiguration {
    public static final String TYPE = "JDBC";
    private static final String DATA_SOURCE_CLASS_NAME = "dataSourceClassName";
    private final String parameter;
    private final DataSourcePoolProperties dataSourcePoolProps;
    private final YamlJdbcConfiguration jdbcConfig;
    private final DatabaseType databaseType;

    public StandardPipelineDataSourceConfiguration(String param) {
        this(param, (Map)YamlEngine.unmarshal((String)param, Map.class));
    }

    public StandardPipelineDataSourceConfiguration(Map<String, Object> poolProps) {
        this(YamlEngine.marshal(poolProps), new HashMap<String, Object>(poolProps));
    }

    private StandardPipelineDataSourceConfiguration(String param, Map<String, Object> yamlConfig) {
        this.parameter = param;
        for (String each : Arrays.asList("minPoolSize", "minimumIdle")) {
            yamlConfig.put(each, "1");
        }
        if (yamlConfig.containsKey("jdbcUrl")) {
            yamlConfig.put("url", yamlConfig.get("jdbcUrl"));
            yamlConfig.remove("jdbcUrl");
        }
        yamlConfig.remove(DATA_SOURCE_CLASS_NAME);
        this.jdbcConfig = (YamlJdbcConfiguration)YamlEngine.unmarshal((String)YamlEngine.marshal(yamlConfig), YamlJdbcConfiguration.class, (boolean)true);
        this.databaseType = DatabaseTypeFactory.get((String)this.jdbcConfig.getUrl());
        yamlConfig.put(DATA_SOURCE_CLASS_NAME, "com.zaxxer.hikari.HikariDataSource");
        this.appendJdbcQueryProperties(this.databaseType, yamlConfig);
        this.dataSourcePoolProps = new YamlDataSourceConfigurationSwapper().swapToDataSourcePoolProperties(yamlConfig);
    }

    public StandardPipelineDataSourceConfiguration(String jdbcUrl, String username, String password) {
        this(StandardPipelineDataSourceConfiguration.wrapParameter(jdbcUrl, username, password));
    }

    private static Map<String, Object> wrapParameter(String jdbcUrl, String username, String password) {
        LinkedHashMap<String, Object> result = new LinkedHashMap<String, Object>(3, 1.0f);
        result.put("url", jdbcUrl);
        result.put("username", username);
        result.put("password", password);
        return result;
    }

    private void appendJdbcQueryProperties(DatabaseType databaseType, Map<String, Object> yamlConfig) {
        Optional extension = DatabaseTypedSPILoader.findService(JdbcQueryPropertiesExtension.class, (DatabaseType)databaseType);
        if (!extension.isPresent()) {
            return;
        }
        String jdbcUrl = this.jdbcConfig.getUrl();
        Properties queryProps = new StandardJdbcUrlParser().parseQueryProperties(jdbcUrl.contains("?") ? jdbcUrl.substring(jdbcUrl.indexOf("?") + 1) : "");
        ((JdbcQueryPropertiesExtension)extension.get()).extendQueryProperties(queryProps);
        String url = new JdbcUrlAppender().appendQueryProperties(jdbcUrl, queryProps);
        this.jdbcConfig.setUrl(url);
        yamlConfig.put("url", url);
    }

    @Override
    public String getType() {
        return TYPE;
    }

    @Override
    public Object getDataSourceConfiguration() {
        return this.dataSourcePoolProps;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof StandardPipelineDataSourceConfiguration)) {
            return false;
        }
        StandardPipelineDataSourceConfiguration other = (StandardPipelineDataSourceConfiguration)o;
        String this$parameter = this.getParameter();
        String other$parameter = other.getParameter();
        return !(this$parameter == null ? other$parameter != null : !this$parameter.equals(other$parameter));
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $parameter = this.getParameter();
        result = result * 59 + ($parameter == null ? 43 : $parameter.hashCode());
        return result;
    }

    @Override
    @Generated
    public String getParameter() {
        return this.parameter;
    }

    @Generated
    public YamlJdbcConfiguration getJdbcConfig() {
        return this.jdbcConfig;
    }

    @Override
    @Generated
    public DatabaseType getDatabaseType() {
        return this.databaseType;
    }
}

