/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.ui.web.controller;

import java.util.List;
import org.apache.shardingsphere.ui.common.domain.RegistryCenterConfig;
import org.apache.shardingsphere.ui.servcie.RegistryCenterConfigService;
import org.apache.shardingsphere.ui.util.RegistryCenterFactory;
import org.apache.shardingsphere.ui.web.response.ResponseResult;
import org.apache.shardingsphere.ui.web.response.ResponseResultUtil;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/reg-center"})
public final class RegistryCenterController {
    @Autowired
    private RegistryCenterConfigService registryCenterConfigService;

    @RequestMapping(value={""}, method={RequestMethod.GET})
    public ResponseResult<List<RegistryCenterConfig>> loadConfigs() {
        return ResponseResultUtil.build(this.registryCenterConfigService.loadAll().getRegistryCenterConfigs());
    }

    @RequestMapping(value={""}, method={RequestMethod.POST})
    public ResponseResult add(@RequestBody RegistryCenterConfig config) {
        this.registryCenterConfigService.add(config);
        return ResponseResultUtil.success();
    }

    @RequestMapping(value={""}, method={RequestMethod.DELETE})
    public ResponseResult delete(@RequestBody RegistryCenterConfig config) {
        this.registryCenterConfigService.delete(config.getName());
        return ResponseResultUtil.success();
    }

    @RequestMapping(value={"/connect"}, method={RequestMethod.POST})
    public ResponseResult<Boolean> connect(@RequestBody RegistryCenterConfig config) {
        RegistryCenterFactory.createRegistryCenter(this.registryCenterConfigService.load(config.getName()));
        this.registryCenterConfigService.setActivated(config.getName());
        return ResponseResultUtil.build(Boolean.TRUE);
    }

    @RequestMapping(value={"/activated"}, method={RequestMethod.GET})
    public ResponseResult<RegistryCenterConfig> activated() {
        return ResponseResultUtil.build(this.registryCenterConfigService.loadActivated().orNull());
    }
}

