/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.ui.web.controller;

import java.util.Collection;
import org.apache.shardingsphere.ui.common.dto.InstanceDTO;
import org.apache.shardingsphere.ui.common.dto.SlaveDataSourceDTO;
import org.apache.shardingsphere.ui.servcie.OrchestrationService;
import org.apache.shardingsphere.ui.web.response.ResponseResult;
import org.apache.shardingsphere.ui.web.response.ResponseResultUtil;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/orchestration"})
public final class OrchestrationController {
    @Autowired
    private OrchestrationService orchestrationService;

    @RequestMapping(value={"/instance"}, method={RequestMethod.GET})
    public ResponseResult<Collection<InstanceDTO>> loadAllInstances() {
        return ResponseResultUtil.build(this.orchestrationService.getALLInstance());
    }

    @RequestMapping(value={"/instance"}, method={RequestMethod.PUT})
    public ResponseResult updateInstanceStatus(@RequestBody InstanceDTO instanceDTO) {
        this.orchestrationService.updateInstanceStatus(instanceDTO.getInstanceId(), instanceDTO.isEnabled());
        return ResponseResultUtil.success();
    }

    @RequestMapping(value={"/datasource"}, method={RequestMethod.GET})
    public ResponseResult<Collection<SlaveDataSourceDTO>> loadAllSlaveDataSources() {
        return ResponseResultUtil.build(this.orchestrationService.getAllSlaveDataSource());
    }

    @RequestMapping(value={"/datasource"}, method={RequestMethod.PUT})
    public ResponseResult updateSlaveDataSourceStatus(@RequestBody SlaveDataSourceDTO slaveDataSourceDTO) {
        this.orchestrationService.updateSlaveDataSourceStatus(slaveDataSourceDTO.getSchema(), slaveDataSourceDTO.getSlaveDataSourceName(), slaveDataSourceDTO.isEnabled());
        return ResponseResultUtil.success();
    }
}

