/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.ui.servcie.impl;

import com.google.common.base.Optional;
import org.apache.shardingsphere.orchestration.internal.registry.config.node.ConfigurationNode;
import org.apache.shardingsphere.orchestration.internal.registry.state.node.StateNode;
import org.apache.shardingsphere.orchestration.reg.api.RegistryCenter;
import org.apache.shardingsphere.ui.common.domain.RegistryCenterConfig;
import org.apache.shardingsphere.ui.common.exception.ShardingUIException;
import org.apache.shardingsphere.ui.servcie.RegistryCenterConfigService;
import org.apache.shardingsphere.ui.servcie.RegistryCenterService;
import org.apache.shardingsphere.ui.util.RegistryCenterFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public final class RegistryCenterServiceImpl
implements RegistryCenterService {
    @Autowired
    private RegistryCenterConfigService registryCenterConfigService;

    @Override
    public RegistryCenter getActivatedRegistryCenter() {
        Optional<RegistryCenterConfig> optional = this.registryCenterConfigService.loadActivated();
        if (optional.isPresent()) {
            return RegistryCenterFactory.createRegistryCenter((RegistryCenterConfig)optional.get());
        }
        throw new ShardingUIException(500, "No activated registry center!");
    }

    @Override
    public ConfigurationNode getActivateConfigurationNode() {
        Optional<RegistryCenterConfig> optional = this.registryCenterConfigService.loadActivated();
        if (optional.isPresent()) {
            return new ConfigurationNode(((RegistryCenterConfig)optional.get()).getOrchestrationName());
        }
        throw new ShardingUIException(500, "No activated registry center!");
    }

    @Override
    public StateNode getActivatedStateNode() {
        Optional<RegistryCenterConfig> optional = this.registryCenterConfigService.loadActivated();
        if (optional.isPresent()) {
            return new StateNode(((RegistryCenterConfig)optional.get()).getOrchestrationName());
        }
        throw new ShardingUIException(500, "No activated registry center!");
    }
}

