/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.ui.servcie.impl;

import org.apache.shardingsphere.ui.servcie.ProxyAuthenticationService;
import org.apache.shardingsphere.ui.servcie.RegistryCenterService;
import org.apache.shardingsphere.ui.util.ConfigurationYamlConverter;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public final class ProxyAuthenticationServiceImpl
implements ProxyAuthenticationService {
    @Autowired
    private RegistryCenterService registryCenterService;

    @Override
    public String getAuthentication() {
        return this.registryCenterService.getActivatedRegistryCenter().get(this.registryCenterService.getActivateConfigurationNode().getAuthenticationPath());
    }

    @Override
    public void updateAuthentication(String authentication) {
        this.checkAuthenticationConfiguration(authentication);
        this.registryCenterService.getActivatedRegistryCenter().persist(this.registryCenterService.getActivateConfigurationNode().getAuthenticationPath(), authentication);
    }

    private void checkAuthenticationConfiguration(String data) {
        try {
            ConfigurationYamlConverter.loadAuthentication(data);
        }
        catch (Exception ex) {
            throw new IllegalArgumentException("authentication configuration is invalid.");
        }
    }
}

