/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.ui.servcie.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.shardingsphere.api.config.masterslave.MasterSlaveRuleConfiguration;
import org.apache.shardingsphere.api.config.sharding.ShardingRuleConfiguration;
import org.apache.shardingsphere.orchestration.internal.registry.state.node.StateNodeStatus;
import org.apache.shardingsphere.ui.common.dto.InstanceDTO;
import org.apache.shardingsphere.ui.common.dto.SlaveDataSourceDTO;
import org.apache.shardingsphere.ui.servcie.OrchestrationService;
import org.apache.shardingsphere.ui.servcie.RegistryCenterService;
import org.apache.shardingsphere.ui.servcie.ShardingSchemaService;
import org.apache.shardingsphere.ui.util.ConfigurationYamlConverter;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public final class OrchestrationServiceImpl
implements OrchestrationService {
    @Autowired
    private RegistryCenterService registryCenterService;
    @Autowired
    private ShardingSchemaService shardingSchemaService;

    @Override
    public Collection<InstanceDTO> getALLInstance() {
        List instanceIds = this.registryCenterService.getActivatedRegistryCenter().getChildrenKeys(this.getInstancesNodeFullRootPath());
        ArrayList<InstanceDTO> result = new ArrayList<InstanceDTO>(instanceIds.size());
        for (String instanceId : instanceIds) {
            String value = this.registryCenterService.getActivatedRegistryCenter().get(this.registryCenterService.getActivatedStateNode().getInstancesNodeFullPath(instanceId));
            result.add(new InstanceDTO(instanceId, !StateNodeStatus.DISABLED.toString().equalsIgnoreCase(value)));
        }
        return result;
    }

    @Override
    public void updateInstanceStatus(String instanceId, boolean enabled) {
        String value = enabled ? "" : StateNodeStatus.DISABLED.toString();
        this.registryCenterService.getActivatedRegistryCenter().persist(this.registryCenterService.getActivatedStateNode().getInstancesNodeFullPath(instanceId), value);
    }

    @Override
    public Collection<SlaveDataSourceDTO> getAllSlaveDataSource() {
        ArrayList<SlaveDataSourceDTO> result = new ArrayList<SlaveDataSourceDTO>();
        for (String schemaName : this.shardingSchemaService.getAllSchemaNames()) {
            String configData = this.shardingSchemaService.getRuleConfiguration(schemaName);
            if (configData.contains("encryptors:\n")) continue;
            if (configData.contains("tables:\n")) {
                this.handleShardingRuleConfiguration(result, configData, schemaName);
                continue;
            }
            this.handleMasterSlaveRuleConfiguration(result, configData, schemaName);
        }
        return result;
    }

    @Override
    public void updateSlaveDataSourceStatus(String schemaNames, String slaveDataSourceName, boolean enabled) {
        String value = enabled ? "" : StateNodeStatus.DISABLED.toString();
        this.registryCenterService.getActivatedRegistryCenter().persist(this.registryCenterService.getActivatedStateNode().getDataSourcesNodeFullPath(schemaNames + "." + slaveDataSourceName), value);
    }

    private String getInstancesNodeFullRootPath() {
        String result = this.registryCenterService.getActivatedStateNode().getInstancesNodeFullPath("");
        return result.substring(0, result.length() - 1);
    }

    private void handleShardingRuleConfiguration(Collection<SlaveDataSourceDTO> slaveDataSourceDTOS, String configData, String schemaName) {
        ShardingRuleConfiguration shardingRuleConfiguration = ConfigurationYamlConverter.loadShardingRuleConfiguration(configData);
        Collection masterSlaveRuleConfigs = shardingRuleConfiguration.getMasterSlaveRuleConfigs();
        for (MasterSlaveRuleConfiguration masterSlaveRuleConfiguration : masterSlaveRuleConfigs) {
            this.addSlaveDataSource(slaveDataSourceDTOS, masterSlaveRuleConfiguration, schemaName);
        }
    }

    private void handleMasterSlaveRuleConfiguration(Collection<SlaveDataSourceDTO> slaveDataSourceDTOS, String configData, String schemaName) {
        MasterSlaveRuleConfiguration masterSlaveRuleConfiguration = ConfigurationYamlConverter.loadMasterSlaveRuleConfiguration(configData);
        this.addSlaveDataSource(slaveDataSourceDTOS, masterSlaveRuleConfiguration, schemaName);
    }

    private void addSlaveDataSource(Collection<SlaveDataSourceDTO> slaveDataSourceDTOS, MasterSlaveRuleConfiguration masterSlaveRuleConfiguration, String schemaName) {
        Collection<String> disabledSchemaDataSourceNames = this.getDisabledSchemaDataSourceNames();
        for (String slaveDateSourceName : masterSlaveRuleConfiguration.getSlaveDataSourceNames()) {
            slaveDataSourceDTOS.add(new SlaveDataSourceDTO(schemaName, masterSlaveRuleConfiguration.getMasterDataSourceName(), slaveDateSourceName, !disabledSchemaDataSourceNames.contains(schemaName + "." + slaveDateSourceName)));
        }
    }

    private Collection<String> getDisabledSchemaDataSourceNames() {
        ArrayList<String> result = new ArrayList<String>();
        List schemaDataSourceNames = this.registryCenterService.getActivatedRegistryCenter().getChildrenKeys(this.registryCenterService.getActivatedStateNode().getDataSourcesNodeFullRootPath());
        for (String schemaDataSourceName : schemaDataSourceNames) {
            String value = this.registryCenterService.getActivatedRegistryCenter().get(this.registryCenterService.getActivatedStateNode().getDataSourcesNodeFullPath(schemaDataSourceName));
            if (!StateNodeStatus.DISABLED.toString().equalsIgnoreCase(value)) continue;
            result.add(schemaDataSourceName);
        }
        return result;
    }
}

