/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.internal.operators.observable;

import io.reactivex.Observable;
import io.reactivex.ObservableSource;
import io.reactivex.Observer;
import io.reactivex.Scheduler;
import io.reactivex.disposables.Disposable;
import io.reactivex.internal.disposables.DisposableHelper;
import io.reactivex.internal.observers.QueueDrainObserver;
import io.reactivex.internal.operators.observable.AbstractObservableWithUpstream;
import io.reactivex.internal.queue.MpscLinkedQueue;
import io.reactivex.internal.util.NotificationLite;
import io.reactivex.observers.SerializedObserver;
import io.reactivex.subjects.UnicastSubject;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;

public final class ObservableWindowTimed<T>
extends AbstractObservableWithUpstream<T, Observable<T>> {
    final long timespan;
    final long timeskip;
    final TimeUnit unit;
    final Scheduler scheduler;
    final long maxSize;
    final int bufferSize;
    final boolean restartTimerOnMaxSize;

    public ObservableWindowTimed(ObservableSource<T> source2, long timespan, long timeskip, TimeUnit unit, Scheduler scheduler, long maxSize, int bufferSize, boolean restartTimerOnMaxSize) {
        super(source2);
        this.timespan = timespan;
        this.timeskip = timeskip;
        this.unit = unit;
        this.scheduler = scheduler;
        this.maxSize = maxSize;
        this.bufferSize = bufferSize;
        this.restartTimerOnMaxSize = restartTimerOnMaxSize;
    }

    @Override
    public void subscribeActual(Observer<? super Observable<T>> t) {
        SerializedObserver<? super Observable<T>> actual = new SerializedObserver<Observable<T>>(t);
        if (this.timespan == this.timeskip) {
            if (this.maxSize == Long.MAX_VALUE) {
                this.source.subscribe(new WindowExactUnboundedObserver(actual, this.timespan, this.unit, this.scheduler, this.bufferSize));
                return;
            }
            this.source.subscribe(new WindowExactBoundedObserver(actual, this.timespan, this.unit, this.scheduler, this.bufferSize, this.maxSize, this.restartTimerOnMaxSize));
            return;
        }
        this.source.subscribe(new WindowSkipObserver(actual, this.timespan, this.timeskip, this.unit, this.scheduler.createWorker(), this.bufferSize));
    }

    static final class WindowSkipObserver<T>
    extends QueueDrainObserver<T, Object, Observable<T>>
    implements Disposable,
    Runnable {
        final long timespan;
        final long timeskip;
        final TimeUnit unit;
        final Scheduler.Worker worker;
        final int bufferSize;
        final List<UnicastSubject<T>> windows;
        Disposable upstream;
        volatile boolean terminated;

        WindowSkipObserver(Observer<? super Observable<T>> actual, long timespan, long timeskip, TimeUnit unit, Scheduler.Worker worker, int bufferSize) {
            super(actual, new MpscLinkedQueue());
            this.timespan = timespan;
            this.timeskip = timeskip;
            this.unit = unit;
            this.worker = worker;
            this.bufferSize = bufferSize;
            this.windows = new LinkedList<UnicastSubject<T>>();
        }

        @Override
        public void onSubscribe(Disposable d) {
            if (DisposableHelper.validate(this.upstream, d)) {
                this.upstream = d;
                this.downstream.onSubscribe(this);
                if (this.cancelled) {
                    return;
                }
                UnicastSubject w = UnicastSubject.create(this.bufferSize);
                this.windows.add(w);
                this.downstream.onNext(w);
                this.worker.schedule(new CompletionTask(w), this.timespan, this.unit);
                this.worker.schedulePeriodically(this, this.timeskip, this.timeskip, this.unit);
            }
        }

        @Override
        public void onNext(T t) {
            if (this.fastEnter()) {
                for (UnicastSubject<T> w : this.windows) {
                    w.onNext(t);
                }
                if (this.leave(-1) == 0) {
                    return;
                }
            } else {
                this.queue.offer(t);
                if (!this.enter()) {
                    return;
                }
            }
            this.drainLoop();
        }

        @Override
        public void onError(Throwable t) {
            this.error = t;
            this.done = true;
            if (this.enter()) {
                this.drainLoop();
            }
            this.downstream.onError(t);
            this.disposeWorker();
        }

        @Override
        public void onComplete() {
            this.done = true;
            if (this.enter()) {
                this.drainLoop();
            }
            this.downstream.onComplete();
            this.disposeWorker();
        }

        @Override
        public void dispose() {
            this.cancelled = true;
        }

        @Override
        public boolean isDisposed() {
            return this.cancelled;
        }

        void disposeWorker() {
            this.worker.dispose();
        }

        void complete(UnicastSubject<T> w) {
            this.queue.offer(new SubjectWork<T>(w, false));
            if (this.enter()) {
                this.drainLoop();
            }
        }

        void drainLoop() {
            MpscLinkedQueue q = (MpscLinkedQueue)this.queue;
            Observer a = this.downstream;
            List<UnicastSubject<T>> ws = this.windows;
            int missed = 1;
            block0: while (true) {
                if (this.terminated) {
                    this.upstream.dispose();
                    this.disposeWorker();
                    q.clear();
                    ws.clear();
                    return;
                }
                boolean d = this.done;
                Object v = q.poll();
                boolean empty = v == null;
                boolean sw = v instanceof SubjectWork;
                if (d && (empty || sw)) {
                    q.clear();
                    Throwable e = this.error;
                    if (e != null) {
                        for (UnicastSubject<T> w : ws) {
                            w.onError(e);
                        }
                    } else {
                        for (UnicastSubject<T> w : ws) {
                            w.onComplete();
                        }
                    }
                    this.disposeWorker();
                    ws.clear();
                    return;
                }
                if (!empty) {
                    UnicastSubject w;
                    if (sw) {
                        SubjectWork work = (SubjectWork)v;
                        if (work.open) {
                            if (this.cancelled) continue;
                            w = UnicastSubject.create(this.bufferSize);
                            ws.add(w);
                            a.onNext(w);
                            this.worker.schedule(new CompletionTask(w), this.timespan, this.unit);
                            continue;
                        }
                        ws.remove(work.w);
                        work.w.onComplete();
                        if (!ws.isEmpty() || !this.cancelled) continue;
                        this.terminated = true;
                        continue;
                    }
                    Iterator<UnicastSubject<T>> iterator2 = ws.iterator();
                    while (true) {
                        if (!iterator2.hasNext()) continue block0;
                        w = iterator2.next();
                        w.onNext(v);
                    }
                }
                if ((missed = this.leave(-missed)) == 0) break;
            }
        }

        @Override
        public void run() {
            UnicastSubject w = UnicastSubject.create(this.bufferSize);
            SubjectWork sw = new SubjectWork(w, true);
            if (!this.cancelled) {
                this.queue.offer(sw);
            }
            if (this.enter()) {
                this.drainLoop();
            }
        }

        final class CompletionTask
        implements Runnable {
            private final UnicastSubject<T> w;

            CompletionTask(UnicastSubject<T> w) {
                this.w = w;
            }

            @Override
            public void run() {
                WindowSkipObserver.this.complete(this.w);
            }
        }

        static final class SubjectWork<T> {
            final UnicastSubject<T> w;
            final boolean open;

            SubjectWork(UnicastSubject<T> w, boolean open) {
                this.w = w;
                this.open = open;
            }
        }
    }

    static final class WindowExactBoundedObserver<T>
    extends QueueDrainObserver<T, Object, Observable<T>>
    implements Disposable {
        final long timespan;
        final TimeUnit unit;
        final Scheduler scheduler;
        final int bufferSize;
        final boolean restartTimerOnMaxSize;
        final long maxSize;
        final Scheduler.Worker worker;
        long count;
        long producerIndex;
        Disposable upstream;
        UnicastSubject<T> window;
        volatile boolean terminated;
        final AtomicReference<Disposable> timer = new AtomicReference();

        WindowExactBoundedObserver(Observer<? super Observable<T>> actual, long timespan, TimeUnit unit, Scheduler scheduler, int bufferSize, long maxSize, boolean restartTimerOnMaxSize) {
            super(actual, new MpscLinkedQueue());
            this.timespan = timespan;
            this.unit = unit;
            this.scheduler = scheduler;
            this.bufferSize = bufferSize;
            this.maxSize = maxSize;
            this.restartTimerOnMaxSize = restartTimerOnMaxSize;
            this.worker = restartTimerOnMaxSize ? scheduler.createWorker() : null;
        }

        @Override
        public void onSubscribe(Disposable d) {
            if (DisposableHelper.validate(this.upstream, d)) {
                this.upstream = d;
                Observer a = this.downstream;
                a.onSubscribe(this);
                if (this.cancelled) {
                    return;
                }
                UnicastSubject w = UnicastSubject.create(this.bufferSize);
                this.window = w;
                a.onNext(w);
                ConsumerIndexHolder consumerIndexHolder = new ConsumerIndexHolder(this.producerIndex, this);
                Disposable task = this.restartTimerOnMaxSize ? this.worker.schedulePeriodically(consumerIndexHolder, this.timespan, this.timespan, this.unit) : this.scheduler.schedulePeriodicallyDirect(consumerIndexHolder, this.timespan, this.timespan, this.unit);
                DisposableHelper.replace(this.timer, task);
            }
        }

        @Override
        public void onNext(T t) {
            if (this.terminated) {
                return;
            }
            if (this.fastEnter()) {
                UnicastSubject<T> w = this.window;
                w.onNext(t);
                long c = this.count + 1L;
                if (c >= this.maxSize) {
                    ++this.producerIndex;
                    this.count = 0L;
                    w.onComplete();
                    w = UnicastSubject.create(this.bufferSize);
                    this.window = w;
                    this.downstream.onNext(w);
                    if (this.restartTimerOnMaxSize) {
                        Disposable tm = this.timer.get();
                        tm.dispose();
                        Disposable task = this.worker.schedulePeriodically(new ConsumerIndexHolder(this.producerIndex, this), this.timespan, this.timespan, this.unit);
                        DisposableHelper.replace(this.timer, task);
                    }
                } else {
                    this.count = c;
                }
                if (this.leave(-1) == 0) {
                    return;
                }
            } else {
                this.queue.offer(NotificationLite.next(t));
                if (!this.enter()) {
                    return;
                }
            }
            this.drainLoop();
        }

        @Override
        public void onError(Throwable t) {
            this.error = t;
            this.done = true;
            if (this.enter()) {
                this.drainLoop();
            }
            this.downstream.onError(t);
            this.disposeTimer();
        }

        @Override
        public void onComplete() {
            this.done = true;
            if (this.enter()) {
                this.drainLoop();
            }
            this.downstream.onComplete();
            this.disposeTimer();
        }

        @Override
        public void dispose() {
            this.cancelled = true;
        }

        @Override
        public boolean isDisposed() {
            return this.cancelled;
        }

        void disposeTimer() {
            DisposableHelper.dispose(this.timer);
            Scheduler.Worker w = this.worker;
            if (w != null) {
                w.dispose();
            }
        }

        void drainLoop() {
            MpscLinkedQueue q = (MpscLinkedQueue)this.queue;
            Observer a = this.downstream;
            UnicastSubject w = this.window;
            int missed = 1;
            while (true) {
                if (this.terminated) {
                    this.upstream.dispose();
                    q.clear();
                    this.disposeTimer();
                    return;
                }
                boolean d = this.done;
                Object o = q.poll();
                boolean empty = o == null;
                boolean isHolder = o instanceof ConsumerIndexHolder;
                if (d && (empty || isHolder)) {
                    this.window = null;
                    q.clear();
                    this.disposeTimer();
                    Throwable err = this.error;
                    if (err != null) {
                        w.onError(err);
                    } else {
                        w.onComplete();
                    }
                    return;
                }
                if (!empty) {
                    if (isHolder) {
                        ConsumerIndexHolder consumerIndexHolder = (ConsumerIndexHolder)o;
                        if (!this.restartTimerOnMaxSize && this.producerIndex != consumerIndexHolder.index) continue;
                        w.onComplete();
                        this.count = 0L;
                        w = UnicastSubject.create(this.bufferSize);
                        this.window = w;
                        a.onNext(w);
                        continue;
                    }
                    w.onNext(NotificationLite.getValue(o));
                    long c = this.count + 1L;
                    if (c >= this.maxSize) {
                        ++this.producerIndex;
                        this.count = 0L;
                        w.onComplete();
                        w = UnicastSubject.create(this.bufferSize);
                        this.window = w;
                        this.downstream.onNext(w);
                        if (!this.restartTimerOnMaxSize) continue;
                        Disposable tm = this.timer.get();
                        tm.dispose();
                        Disposable task = this.worker.schedulePeriodically(new ConsumerIndexHolder(this.producerIndex, this), this.timespan, this.timespan, this.unit);
                        if (this.timer.compareAndSet(tm, task)) continue;
                        task.dispose();
                        continue;
                    }
                    this.count = c;
                    continue;
                }
                if ((missed = this.leave(-missed)) == 0) break;
            }
        }

        static final class ConsumerIndexHolder
        implements Runnable {
            final long index;
            final WindowExactBoundedObserver<?> parent;

            ConsumerIndexHolder(long index, WindowExactBoundedObserver<?> parent) {
                this.index = index;
                this.parent = parent;
            }

            @Override
            public void run() {
                WindowExactBoundedObserver<?> p = this.parent;
                if (!((WindowExactBoundedObserver)p).cancelled) {
                    ((WindowExactBoundedObserver)p).queue.offer(this);
                } else {
                    p.terminated = true;
                    p.disposeTimer();
                }
                if (p.enter()) {
                    p.drainLoop();
                }
            }
        }
    }

    static final class WindowExactUnboundedObserver<T>
    extends QueueDrainObserver<T, Object, Observable<T>>
    implements Observer<T>,
    Disposable,
    Runnable {
        final long timespan;
        final TimeUnit unit;
        final Scheduler scheduler;
        final int bufferSize;
        Disposable upstream;
        UnicastSubject<T> window;
        final AtomicReference<Disposable> timer = new AtomicReference();
        static final Object NEXT = new Object();
        volatile boolean terminated;

        WindowExactUnboundedObserver(Observer<? super Observable<T>> actual, long timespan, TimeUnit unit, Scheduler scheduler, int bufferSize) {
            super(actual, new MpscLinkedQueue());
            this.timespan = timespan;
            this.unit = unit;
            this.scheduler = scheduler;
            this.bufferSize = bufferSize;
        }

        @Override
        public void onSubscribe(Disposable d) {
            if (DisposableHelper.validate(this.upstream, d)) {
                this.upstream = d;
                this.window = UnicastSubject.create(this.bufferSize);
                Observer a = this.downstream;
                a.onSubscribe(this);
                a.onNext(this.window);
                if (!this.cancelled) {
                    Disposable task = this.scheduler.schedulePeriodicallyDirect(this, this.timespan, this.timespan, this.unit);
                    DisposableHelper.replace(this.timer, task);
                }
            }
        }

        @Override
        public void onNext(T t) {
            if (this.terminated) {
                return;
            }
            if (this.fastEnter()) {
                this.window.onNext(t);
                if (this.leave(-1) == 0) {
                    return;
                }
            } else {
                this.queue.offer(NotificationLite.next(t));
                if (!this.enter()) {
                    return;
                }
            }
            this.drainLoop();
        }

        @Override
        public void onError(Throwable t) {
            this.error = t;
            this.done = true;
            if (this.enter()) {
                this.drainLoop();
            }
            this.disposeTimer();
            this.downstream.onError(t);
        }

        @Override
        public void onComplete() {
            this.done = true;
            if (this.enter()) {
                this.drainLoop();
            }
            this.disposeTimer();
            this.downstream.onComplete();
        }

        @Override
        public void dispose() {
            this.cancelled = true;
        }

        @Override
        public boolean isDisposed() {
            return this.cancelled;
        }

        void disposeTimer() {
            DisposableHelper.dispose(this.timer);
        }

        @Override
        public void run() {
            if (this.cancelled) {
                this.terminated = true;
                this.disposeTimer();
            }
            this.queue.offer(NEXT);
            if (this.enter()) {
                this.drainLoop();
            }
        }

        void drainLoop() {
            MpscLinkedQueue q = (MpscLinkedQueue)this.queue;
            Observer a = this.downstream;
            UnicastSubject w = this.window;
            int missed = 1;
            while (true) {
                boolean term = this.terminated;
                boolean d = this.done;
                Object o = q.poll();
                if (d && (o == null || o == NEXT)) {
                    this.window = null;
                    q.clear();
                    this.disposeTimer();
                    Throwable err = this.error;
                    if (err != null) {
                        w.onError(err);
                    } else {
                        w.onComplete();
                    }
                    return;
                }
                if (o != null) {
                    if (o == NEXT) {
                        w.onComplete();
                        if (!term) {
                            w = UnicastSubject.create(this.bufferSize);
                            this.window = w;
                            a.onNext(w);
                            continue;
                        }
                        this.upstream.dispose();
                        continue;
                    }
                    w.onNext(NotificationLite.getValue(o));
                    continue;
                }
                if ((missed = this.leave(-missed)) == 0) break;
            }
        }
    }
}

