/*
 * Decompiled with CFR 0.152.
 */
package org.web3j.protocol.rx;

import io.reactivex.BackpressureStrategy;
import io.reactivex.Flowable;
import io.reactivex.FlowableEmitter;
import io.reactivex.Scheduler;
import io.reactivex.schedulers.Schedulers;
import java.io.IOException;
import java.math.BigInteger;
import java.util.List;
import java.util.concurrent.ScheduledExecutorService;
import java.util.stream.Collectors;
import org.web3j.protocol.Web3j;
import org.web3j.protocol.core.DefaultBlockParameter;
import org.web3j.protocol.core.DefaultBlockParameterName;
import org.web3j.protocol.core.DefaultBlockParameterNumber;
import org.web3j.protocol.core.Request;
import org.web3j.protocol.core.filters.BlockFilter;
import org.web3j.protocol.core.filters.Filter;
import org.web3j.protocol.core.filters.LogFilter;
import org.web3j.protocol.core.filters.PendingTransactionFilter;
import org.web3j.protocol.core.methods.request.EthFilter;
import org.web3j.protocol.core.methods.response.EthBlock;
import org.web3j.protocol.core.methods.response.Log;
import org.web3j.protocol.core.methods.response.Transaction;
import org.web3j.utils.Flowables;

public class JsonRpc2_0Rx {
    private final Web3j web3j;
    private final ScheduledExecutorService scheduledExecutorService;
    private final Scheduler scheduler;

    public JsonRpc2_0Rx(Web3j web3j, ScheduledExecutorService scheduledExecutorService) {
        this.web3j = web3j;
        this.scheduledExecutorService = scheduledExecutorService;
        this.scheduler = Schedulers.from(scheduledExecutorService);
    }

    public Flowable<String> ethBlockHashFlowable(long pollingInterval) {
        return Flowable.create(subscriber -> {
            BlockFilter blockFilter = new BlockFilter(this.web3j, subscriber::onNext);
            this.run(blockFilter, subscriber, pollingInterval);
        }, BackpressureStrategy.BUFFER);
    }

    public Flowable<String> ethPendingTransactionHashFlowable(long pollingInterval) {
        return Flowable.create(subscriber -> {
            PendingTransactionFilter pendingTransactionFilter = new PendingTransactionFilter(this.web3j, subscriber::onNext);
            this.run(pendingTransactionFilter, subscriber, pollingInterval);
        }, BackpressureStrategy.BUFFER);
    }

    public Flowable<Log> ethLogFlowable(EthFilter ethFilter, long pollingInterval) {
        return Flowable.create(subscriber -> {
            LogFilter logFilter = new LogFilter(this.web3j, subscriber::onNext, ethFilter);
            this.run(logFilter, subscriber, pollingInterval);
        }, BackpressureStrategy.BUFFER);
    }

    private <T> void run(Filter<T> filter, FlowableEmitter<? super T> emitter, long pollingInterval) {
        filter.run(this.scheduledExecutorService, pollingInterval);
        emitter.setCancellable(filter::cancel);
    }

    public Flowable<Transaction> transactionFlowable(long pollingInterval) {
        return this.blockFlowable(true, pollingInterval).flatMapIterable(JsonRpc2_0Rx::toTransactions);
    }

    public Flowable<Transaction> pendingTransactionFlowable(long pollingInterval) {
        return this.ethPendingTransactionHashFlowable(pollingInterval).flatMap(transactionHash -> this.web3j.ethGetTransactionByHash((String)transactionHash).flowable()).filter(ethTransaction -> ethTransaction.getTransaction().isPresent()).map(ethTransaction -> ethTransaction.getTransaction().get());
    }

    public Flowable<EthBlock> blockFlowable(boolean fullTransactionObjects, long pollingInterval) {
        return this.ethBlockHashFlowable(pollingInterval).flatMap(blockHash -> this.web3j.ethGetBlockByHash((String)blockHash, fullTransactionObjects).flowable());
    }

    public Flowable<EthBlock> replayBlocksFlowable(DefaultBlockParameter startBlock, DefaultBlockParameter endBlock, boolean fullTransactionObjects) {
        return this.replayBlocksFlowable(startBlock, endBlock, fullTransactionObjects, true);
    }

    public Flowable<EthBlock> replayBlocksFlowable(DefaultBlockParameter startBlock, DefaultBlockParameter endBlock, boolean fullTransactionObjects, boolean ascending) {
        return this.replayBlocksFlowableSync(startBlock, endBlock, fullTransactionObjects, ascending).subscribeOn(this.scheduler);
    }

    private Flowable<EthBlock> replayBlocksFlowableSync(DefaultBlockParameter startBlock, DefaultBlockParameter endBlock, boolean fullTransactionObjects) {
        return this.replayBlocksFlowableSync(startBlock, endBlock, fullTransactionObjects, true);
    }

    private Flowable<EthBlock> replayBlocksFlowableSync(DefaultBlockParameter startBlock, DefaultBlockParameter endBlock, boolean containsFullTransactionObjects, boolean isAscending) {
        BigInteger endBlockNumber;
        BigInteger startBlockNumber;
        try {
            startBlockNumber = this.getBlockNumber(startBlock);
            endBlockNumber = this.getBlockNumber(endBlock);
        }
        catch (IOException e) {
            return Flowable.error(e);
        }
        return Flowables.range(startBlockNumber, endBlockNumber, isAscending).map(DefaultBlockParameterNumber::new).map(number -> this.web3j.ethGetBlockByNumber((DefaultBlockParameter)number, containsFullTransactionObjects)).flatMap(Request::flowable);
    }

    public Flowable<Transaction> replayTransactionsFlowable(DefaultBlockParameter startBlock, DefaultBlockParameter endBlock) {
        return this.replayBlocksFlowable(startBlock, endBlock, true).flatMapIterable(JsonRpc2_0Rx::toTransactions);
    }

    public Flowable<EthBlock> replayPastBlocksFlowable(DefaultBlockParameter startBlock, boolean fullTransactionObjects, Flowable<EthBlock> onCompleteFlowable) {
        return this.replayPastBlocksFlowableSync(startBlock, fullTransactionObjects, onCompleteFlowable).subscribeOn(this.scheduler);
    }

    public Flowable<EthBlock> replayPastBlocksFlowable(DefaultBlockParameter startBlock, boolean fullTransactionObjects) {
        return this.replayPastBlocksFlowable(startBlock, fullTransactionObjects, Flowable.empty());
    }

    private Flowable<EthBlock> replayPastBlocksFlowableSync(DefaultBlockParameter startBlock, boolean fullTransactionObjects, Flowable<EthBlock> onCompleteFlowable) {
        BigInteger latestBlockNumber;
        BigInteger startBlockNumber;
        try {
            startBlockNumber = this.getBlockNumber(startBlock);
            latestBlockNumber = this.getLatestBlockNumber();
        }
        catch (IOException e) {
            return Flowable.error(e);
        }
        if (startBlockNumber.compareTo(latestBlockNumber) > -1) {
            return onCompleteFlowable;
        }
        return Flowable.concat(this.replayBlocksFlowableSync(new DefaultBlockParameterNumber(startBlockNumber), new DefaultBlockParameterNumber(latestBlockNumber), fullTransactionObjects), Flowable.defer(() -> this.replayPastBlocksFlowableSync(new DefaultBlockParameterNumber(latestBlockNumber.add(BigInteger.ONE)), fullTransactionObjects, onCompleteFlowable)));
    }

    public Flowable<Transaction> replayPastTransactionsFlowable(DefaultBlockParameter startBlock) {
        return this.replayPastBlocksFlowable(startBlock, true, Flowable.empty()).flatMapIterable(JsonRpc2_0Rx::toTransactions);
    }

    public Flowable<EthBlock> replayPastAndFutureBlocksFlowable(DefaultBlockParameter startBlock, boolean fullTransactionObjects, long pollingInterval) {
        return this.replayPastBlocksFlowable(startBlock, fullTransactionObjects, this.blockFlowable(fullTransactionObjects, pollingInterval));
    }

    public Flowable<Transaction> replayPastAndFutureTransactionsFlowable(DefaultBlockParameter startBlock, long pollingInterval) {
        return this.replayPastAndFutureBlocksFlowable(startBlock, true, pollingInterval).flatMapIterable(JsonRpc2_0Rx::toTransactions);
    }

    private BigInteger getLatestBlockNumber() throws IOException {
        return this.getBlockNumber(DefaultBlockParameterName.LATEST);
    }

    private BigInteger getBlockNumber(DefaultBlockParameter defaultBlockParameter) throws IOException {
        if (defaultBlockParameter instanceof DefaultBlockParameterNumber) {
            return ((DefaultBlockParameterNumber)defaultBlockParameter).getBlockNumber();
        }
        EthBlock latestEthBlock = this.web3j.ethGetBlockByNumber(defaultBlockParameter, false).send();
        return latestEthBlock.getBlock().getNumber();
    }

    private static List<Transaction> toTransactions(EthBlock ethBlock) {
        return ethBlock.getBlock().getTransactions().stream().map(transactionResult -> (Transaction)transactionResult.get()).collect(Collectors.toList());
    }
}

