/*
 * Decompiled with CFR 0.152.
 */
package org.web3j.abi;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.web3j.abi.FunctionReturnDecoder;
import org.web3j.abi.TypeDecoder;
import org.web3j.abi.TypeReference;
import org.web3j.abi.Utils;
import org.web3j.abi.datatypes.Array;
import org.web3j.abi.datatypes.Bytes;
import org.web3j.abi.datatypes.BytesType;
import org.web3j.abi.datatypes.DynamicArray;
import org.web3j.abi.datatypes.DynamicBytes;
import org.web3j.abi.datatypes.DynamicStruct;
import org.web3j.abi.datatypes.StaticArray;
import org.web3j.abi.datatypes.StaticStruct;
import org.web3j.abi.datatypes.Type;
import org.web3j.abi.datatypes.Utf8String;
import org.web3j.abi.datatypes.generated.Bytes32;
import org.web3j.utils.Numeric;
import org.web3j.utils.Strings;

public class DefaultFunctionReturnDecoder
extends FunctionReturnDecoder {
    @Override
    public List<Type> decodeFunctionResult(String rawInput, List<TypeReference<Type>> outputParameters) {
        String input = Numeric.cleanHexPrefix(rawInput);
        if (Strings.isEmpty(input)) {
            return Collections.emptyList();
        }
        return DefaultFunctionReturnDecoder.build(input, outputParameters);
    }

    @Override
    public <T extends Type> Type decodeEventParameter(String rawInput, TypeReference<T> typeReference) {
        String input = Numeric.cleanHexPrefix(rawInput);
        try {
            Class<T> type = typeReference.getClassType();
            if (Bytes.class.isAssignableFrom(type)) {
                Class<?> bytesClass = Class.forName(type.getName());
                return TypeDecoder.decodeBytes(input, bytesClass);
            }
            if (Array.class.isAssignableFrom(type) || BytesType.class.isAssignableFrom(type) || Utf8String.class.isAssignableFrom(type)) {
                return TypeDecoder.decodeBytes(input, Bytes32.class);
            }
            return TypeDecoder.decode(input, type);
        }
        catch (ClassNotFoundException e) {
            throw new UnsupportedOperationException("Invalid class reference provided", e);
        }
    }

    private static List<Type> build(String input, List<TypeReference<Type>> outputParameters) {
        ArrayList<Type> results = new ArrayList<Type>(outputParameters.size());
        int offset = 0;
        for (TypeReference<Type> typeReference : outputParameters) {
            try {
                int length;
                Type result;
                int hexStringDataOffset = DefaultFunctionReturnDecoder.getDataOffset(input, offset, typeReference);
                Class<Type> classType = typeReference.getClassType();
                if (DynamicStruct.class.isAssignableFrom(classType)) {
                    result = TypeDecoder.decodeDynamicStruct(input, hexStringDataOffset, typeReference);
                    offset += 64;
                } else if (DynamicArray.class.isAssignableFrom(classType)) {
                    result = TypeDecoder.decodeDynamicArray(input, hexStringDataOffset, typeReference);
                    offset += 64;
                } else if (typeReference instanceof TypeReference.StaticArrayTypeReference) {
                    length = ((TypeReference.StaticArrayTypeReference)typeReference).getSize();
                    result = TypeDecoder.decodeStaticArray(input, hexStringDataOffset, typeReference, length);
                    offset += length * 64;
                } else if (StaticStruct.class.isAssignableFrom(classType)) {
                    result = TypeDecoder.decodeStaticStruct(input, hexStringDataOffset, typeReference);
                    offset += Utils.staticStructNestedPublicFieldsFlatList(classType).size() * 64;
                } else if (StaticArray.class.isAssignableFrom(classType)) {
                    length = Integer.parseInt(classType.getSimpleName().substring(StaticArray.class.getSimpleName().length()));
                    result = TypeDecoder.decodeStaticArray(input, hexStringDataOffset, typeReference, length);
                    offset = DynamicStruct.class.isAssignableFrom(Utils.getParameterizedTypeFromArray(typeReference)) ? (offset += 64) : (StaticStruct.class.isAssignableFrom(Utils.getParameterizedTypeFromArray(typeReference)) ? (offset += Utils.staticStructNestedPublicFieldsFlatList(Utils.getParameterizedTypeFromArray(typeReference)).size() * length * 64) : (offset += length * 64));
                } else {
                    result = TypeDecoder.decode(input, hexStringDataOffset, classType);
                    offset += 64;
                }
                results.add(result);
            }
            catch (ClassNotFoundException e) {
                throw new UnsupportedOperationException("Invalid class reference provided", e);
            }
        }
        return results;
    }

    public static <T extends Type> int getDataOffset(String input, int offset, TypeReference<?> typeReference) throws ClassNotFoundException {
        Class<?> type = typeReference.getClassType();
        if (DynamicBytes.class.isAssignableFrom(type) || Utf8String.class.isAssignableFrom(type) || DynamicArray.class.isAssignableFrom(type) || DefaultFunctionReturnDecoder.hasDynamicOffsetInStaticArray(typeReference, offset)) {
            return TypeDecoder.decodeUintAsInt(input, offset) << 1;
        }
        return offset;
    }

    private static boolean hasDynamicOffsetInStaticArray(TypeReference<?> typeReference, int offset) throws ClassNotFoundException {
        Class<?> type = typeReference.getClassType();
        try {
            return StaticArray.class.isAssignableFrom(type) && (DynamicStruct.class.isAssignableFrom(Utils.getParameterizedTypeFromArray(typeReference)) || TypeDecoder.isDynamic(Utils.getParameterizedTypeFromArray(typeReference)));
        }
        catch (ClassCastException e) {
            return false;
        }
    }
}

