/*
 * Decompiled with CFR 0.152.
 */
package org.web3j.crypto;

import java.io.File;
import java.io.IOException;
import org.web3j.crypto.Bip32ECKeyPair;
import org.web3j.crypto.Bip39Wallet;
import org.web3j.crypto.CipherException;
import org.web3j.crypto.Credentials;
import org.web3j.crypto.MnemonicUtils;
import org.web3j.crypto.SecureRandomUtils;
import org.web3j.crypto.WalletUtils;

public class Bip44WalletUtils
extends WalletUtils {
    public static Bip39Wallet generateBip44Wallet(String password, File destinationDirectory) throws CipherException, IOException {
        return Bip44WalletUtils.generateBip44Wallet(password, destinationDirectory, false);
    }

    public static Bip39Wallet generateBip44Wallet(String password, File destinationDirectory, boolean testNet) throws CipherException, IOException {
        byte[] initialEntropy = new byte[16];
        SecureRandomUtils.secureRandom().nextBytes(initialEntropy);
        String mnemonic = MnemonicUtils.generateMnemonic(initialEntropy);
        byte[] seed = MnemonicUtils.generateSeed(mnemonic, null);
        Bip32ECKeyPair masterKeypair = Bip32ECKeyPair.generateKeyPair(seed);
        Bip32ECKeyPair bip44Keypair = Bip44WalletUtils.generateBip44KeyPair(masterKeypair, testNet);
        String walletFile = Bip44WalletUtils.generateWalletFile(password, bip44Keypair, destinationDirectory, false);
        return new Bip39Wallet(walletFile, mnemonic);
    }

    public static Bip32ECKeyPair generateBip44KeyPair(Bip32ECKeyPair master) {
        return Bip44WalletUtils.generateBip44KeyPair(master, false);
    }

    public static Bip32ECKeyPair generateBip44KeyPair(Bip32ECKeyPair master, boolean testNet) {
        if (testNet) {
            int[] path = new int[]{-2147483604, Integer.MIN_VALUE, Integer.MIN_VALUE, 0};
            return Bip32ECKeyPair.deriveKeyPair(master, path);
        }
        int[] path = new int[]{-2147483604, -2147483588, Integer.MIN_VALUE, 0, 0};
        return Bip32ECKeyPair.deriveKeyPair(master, path);
    }

    public static Credentials loadBip44Credentials(String password, String mnemonic) {
        return Bip44WalletUtils.loadBip44Credentials(password, mnemonic, false);
    }

    public static Credentials loadBip44Credentials(String password, String mnemonic, boolean testNet) {
        byte[] seed = MnemonicUtils.generateSeed(mnemonic, password);
        Bip32ECKeyPair masterKeypair = Bip32ECKeyPair.generateKeyPair(seed);
        Bip32ECKeyPair bip44Keypair = Bip44WalletUtils.generateBip44KeyPair(masterKeypair, testNet);
        return Credentials.create(bip44Keypair);
    }
}

