/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.internal.operators.single;

import io.reactivex.Single;
import io.reactivex.SingleObserver;
import io.reactivex.SingleSource;
import io.reactivex.disposables.Disposable;
import io.reactivex.exceptions.Exceptions;
import io.reactivex.functions.BiPredicate;

public final class SingleContains<T>
extends Single<Boolean> {
    final SingleSource<T> source;
    final Object value;
    final BiPredicate<Object, Object> comparer;

    public SingleContains(SingleSource<T> source2, Object value, BiPredicate<Object, Object> comparer) {
        this.source = source2;
        this.value = value;
        this.comparer = comparer;
    }

    @Override
    protected void subscribeActual(SingleObserver<? super Boolean> observer) {
        this.source.subscribe(new ContainsSingleObserver(observer));
    }

    final class ContainsSingleObserver
    implements SingleObserver<T> {
        private final SingleObserver<? super Boolean> downstream;

        ContainsSingleObserver(SingleObserver<? super Boolean> observer) {
            this.downstream = observer;
        }

        @Override
        public void onSubscribe(Disposable d) {
            this.downstream.onSubscribe(d);
        }

        @Override
        public void onSuccess(T v) {
            boolean b;
            try {
                b = SingleContains.this.comparer.test(v, SingleContains.this.value);
            }
            catch (Throwable ex) {
                Exceptions.throwIfFatal(ex);
                this.downstream.onError(ex);
                return;
            }
            this.downstream.onSuccess((Boolean)b);
        }

        @Override
        public void onError(Throwable e) {
            this.downstream.onError(e);
        }
    }
}

