/*
 * Decompiled with CFR 0.152.
 */
package io.sentry;

import io.sentry.SpanId;
import io.sentry.exception.InvalidSentryTraceHeaderException;
import io.sentry.protocol.SentryId;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class SentryTraceHeader {
    public static final String SENTRY_TRACE_HEADER = "sentry-trace";
    @NotNull
    private final SentryId traceId;
    @NotNull
    private final SpanId spanId;
    @Nullable
    private final Boolean sampled;

    public SentryTraceHeader(@NotNull SentryId traceId, @NotNull SpanId spanId, @Nullable Boolean sampled) {
        this.traceId = traceId;
        this.spanId = spanId;
        this.sampled = sampled;
    }

    public SentryTraceHeader(@NotNull String value) throws InvalidSentryTraceHeaderException {
        String[] parts = value.split("-", -1);
        if (parts.length < 2) {
            throw new InvalidSentryTraceHeaderException(value);
        }
        this.sampled = parts.length == 3 ? Boolean.valueOf("1".equals(parts[2])) : null;
        this.traceId = new SentryId(parts[0]);
        this.spanId = new SpanId(parts[1]);
    }

    @NotNull
    public String getName() {
        return SENTRY_TRACE_HEADER;
    }

    @NotNull
    public String getValue() {
        if (this.sampled != null) {
            return String.format("%s-%s-%s", this.traceId, this.spanId, this.sampled != false ? "1" : "0");
        }
        return String.format("%s-%s", this.traceId, this.spanId);
    }

    @NotNull
    public SentryId getTraceId() {
        return this.traceId;
    }

    @NotNull
    public SpanId getSpanId() {
        return this.spanId;
    }

    @Nullable
    public Boolean isSampled() {
        return this.sampled;
    }
}

