/*
 * Decompiled with CFR 0.152.
 */
package io.sentry;

import io.sentry.Breadcrumb;
import io.sentry.CustomSamplingContext;
import io.sentry.IHub;
import io.sentry.ISentryClient;
import io.sentry.ISpan;
import io.sentry.ITransaction;
import io.sentry.Integration;
import io.sentry.NoOpSentryClient;
import io.sentry.NoOpTransaction;
import io.sentry.SamplingContext;
import io.sentry.Scope;
import io.sentry.ScopeCallback;
import io.sentry.SentryClient;
import io.sentry.SentryEnvelope;
import io.sentry.SentryEvent;
import io.sentry.SentryLevel;
import io.sentry.SentryOptions;
import io.sentry.SentryTraceHeader;
import io.sentry.SentryTracer;
import io.sentry.Session;
import io.sentry.SpanContext;
import io.sentry.Stack;
import io.sentry.TracesSampler;
import io.sentry.TransactionContext;
import io.sentry.UserFeedback;
import io.sentry.hints.SessionEndHint;
import io.sentry.hints.SessionStartHint;
import io.sentry.protocol.SentryId;
import io.sentry.protocol.SentryTransaction;
import io.sentry.protocol.User;
import io.sentry.util.ExceptionUtils;
import io.sentry.util.Objects;
import io.sentry.util.Pair;
import java.io.Closeable;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class Hub
implements IHub {
    @NotNull
    private volatile SentryId lastEventId;
    @NotNull
    private final SentryOptions options;
    private volatile boolean isEnabled;
    @NotNull
    private final Stack stack;
    @NotNull
    private final TracesSampler tracesSampler;
    @NotNull
    private final Map<Throwable, Pair<ISpan, String>> throwableToSpan = Collections.synchronizedMap(new WeakHashMap());

    public Hub(@NotNull SentryOptions options) {
        this(options, Hub.createRootStackItem(options));
    }

    private Hub(@NotNull SentryOptions options, @NotNull Stack stack) {
        Hub.validateOptions(options);
        this.options = options;
        this.tracesSampler = new TracesSampler(options);
        this.stack = stack;
        this.lastEventId = SentryId.EMPTY_ID;
        this.isEnabled = true;
    }

    private Hub(@NotNull SentryOptions options, @NotNull Stack.StackItem rootStackItem) {
        this(options, new Stack(options.getLogger(), rootStackItem));
    }

    private static void validateOptions(@NotNull SentryOptions options) {
        Objects.requireNonNull(options, "SentryOptions is required.");
        if (options.getDsn() == null || options.getDsn().isEmpty()) {
            throw new IllegalArgumentException("Hub requires a DSN to be instantiated. Considering using the NoOpHub is no DSN is available.");
        }
    }

    private static Stack.StackItem createRootStackItem(@NotNull SentryOptions options) {
        Hub.validateOptions(options);
        Scope scope = new Scope(options);
        SentryClient client = new SentryClient(options);
        return new Stack.StackItem(options, client, scope);
    }

    @Override
    public boolean isEnabled() {
        return this.isEnabled;
    }

    @Override
    @NotNull
    public SentryId captureEvent(@NotNull SentryEvent event, @Nullable Object hint) {
        SentryId sentryId = SentryId.EMPTY_ID;
        if (!this.isEnabled()) {
            this.options.getLogger().log(SentryLevel.WARNING, "Instance is disabled and this 'captureEvent' call is a no-op.", new Object[0]);
        } else if (event == null) {
            this.options.getLogger().log(SentryLevel.WARNING, "captureEvent called with null parameter.", new Object[0]);
        } else {
            try {
                this.assignTraceContext(event);
                Stack.StackItem item = this.stack.peek();
                sentryId = item.getClient().captureEvent(event, item.getScope(), hint);
            }
            catch (Exception e) {
                this.options.getLogger().log(SentryLevel.ERROR, "Error while capturing event with id: " + event.getEventId(), e);
            }
        }
        this.lastEventId = sentryId;
        return sentryId;
    }

    @Override
    @NotNull
    public SentryId captureMessage(@NotNull String message, @NotNull SentryLevel level) {
        SentryId sentryId = SentryId.EMPTY_ID;
        if (!this.isEnabled()) {
            this.options.getLogger().log(SentryLevel.WARNING, "Instance is disabled and this 'captureMessage' call is a no-op.", new Object[0]);
        } else if (message == null) {
            this.options.getLogger().log(SentryLevel.WARNING, "captureMessage called with null parameter.", new Object[0]);
        } else {
            try {
                Stack.StackItem item = this.stack.peek();
                sentryId = item.getClient().captureMessage(message, level, item.getScope());
            }
            catch (Exception e) {
                this.options.getLogger().log(SentryLevel.ERROR, "Error while capturing message: " + message, e);
            }
        }
        this.lastEventId = sentryId;
        return sentryId;
    }

    @Override
    @ApiStatus.Internal
    @NotNull
    public SentryId captureEnvelope(@NotNull SentryEnvelope envelope, @Nullable Object hint) {
        Objects.requireNonNull(envelope, "SentryEnvelope is required.");
        SentryId sentryId = SentryId.EMPTY_ID;
        if (!this.isEnabled()) {
            this.options.getLogger().log(SentryLevel.WARNING, "Instance is disabled and this 'captureEnvelope' call is a no-op.", new Object[0]);
        } else {
            try {
                SentryId capturedEnvelopeId = this.stack.peek().getClient().captureEnvelope(envelope, hint);
                if (capturedEnvelopeId != null) {
                    sentryId = capturedEnvelopeId;
                }
            }
            catch (Exception e) {
                this.options.getLogger().log(SentryLevel.ERROR, "Error while capturing envelope.", e);
            }
        }
        this.lastEventId = sentryId;
        return sentryId;
    }

    @Override
    @NotNull
    public SentryId captureException(@NotNull Throwable throwable, @Nullable Object hint) {
        SentryId sentryId = SentryId.EMPTY_ID;
        if (!this.isEnabled()) {
            this.options.getLogger().log(SentryLevel.WARNING, "Instance is disabled and this 'captureException' call is a no-op.", new Object[0]);
        } else if (throwable == null) {
            this.options.getLogger().log(SentryLevel.WARNING, "captureException called with null parameter.", new Object[0]);
        } else {
            try {
                Stack.StackItem item = this.stack.peek();
                SentryEvent event = new SentryEvent(throwable);
                this.assignTraceContext(event);
                sentryId = item.getClient().captureEvent(event, item.getScope(), hint);
            }
            catch (Exception e) {
                this.options.getLogger().log(SentryLevel.ERROR, "Error while capturing exception: " + throwable.getMessage(), e);
            }
        }
        this.lastEventId = sentryId;
        return sentryId;
    }

    private void assignTraceContext(@NotNull SentryEvent event) {
        Pair<ISpan, String> pair;
        if (event.getThrowable() != null && (pair = this.throwableToSpan.get(ExceptionUtils.findRootCause(event.getThrowable()))) != null) {
            ISpan span = pair.getFirst();
            if (event.getContexts().getTrace() == null && span != null) {
                event.getContexts().setTrace(span.getSpanContext());
            }
            String transactionName = pair.getSecond();
            if (event.getTransaction() == null && transactionName != null) {
                event.setTransaction(transactionName);
            }
        }
    }

    @Override
    public void captureUserFeedback(@NotNull UserFeedback userFeedback) {
        if (!this.isEnabled()) {
            this.options.getLogger().log(SentryLevel.WARNING, "Instance is disabled and this 'captureUserFeedback' call is a no-op.", new Object[0]);
        } else {
            try {
                Stack.StackItem item = this.stack.peek();
                item.getClient().captureUserFeedback(userFeedback);
            }
            catch (Exception e) {
                this.options.getLogger().log(SentryLevel.ERROR, "Error while capturing captureUserFeedback: " + userFeedback.toString(), e);
            }
        }
    }

    @Override
    public void startSession() {
        if (!this.isEnabled()) {
            this.options.getLogger().log(SentryLevel.WARNING, "Instance is disabled and this 'startSession' call is a no-op.", new Object[0]);
        } else {
            Stack.StackItem item = this.stack.peek();
            Scope.SessionPair pair = item.getScope().startSession();
            if (pair != null) {
                if (pair.getPrevious() != null) {
                    item.getClient().captureSession(pair.getPrevious(), new SessionEndHint());
                }
                item.getClient().captureSession(pair.getCurrent(), new SessionStartHint());
            } else {
                this.options.getLogger().log(SentryLevel.WARNING, "Session could not be started.", new Object[0]);
            }
        }
    }

    @Override
    public void endSession() {
        if (!this.isEnabled()) {
            this.options.getLogger().log(SentryLevel.WARNING, "Instance is disabled and this 'endSession' call is a no-op.", new Object[0]);
        } else {
            Stack.StackItem item = this.stack.peek();
            Session previousSession = item.getScope().endSession();
            if (previousSession != null) {
                item.getClient().captureSession(previousSession, new SessionEndHint());
            }
        }
    }

    @Override
    public void close() {
        if (!this.isEnabled()) {
            this.options.getLogger().log(SentryLevel.WARNING, "Instance is disabled and this 'close' call is a no-op.", new Object[0]);
        } else {
            try {
                for (Integration integration : this.options.getIntegrations()) {
                    if (!(integration instanceof Closeable)) continue;
                    ((Closeable)((Object)integration)).close();
                }
                this.options.getExecutorService().close(this.options.getShutdownTimeout());
                Stack.StackItem item = this.stack.peek();
                item.getClient().close();
            }
            catch (Exception e) {
                this.options.getLogger().log(SentryLevel.ERROR, "Error while closing the Hub.", e);
            }
            this.isEnabled = false;
        }
    }

    @Override
    public void addBreadcrumb(@NotNull Breadcrumb breadcrumb, @Nullable Object hint) {
        if (!this.isEnabled()) {
            this.options.getLogger().log(SentryLevel.WARNING, "Instance is disabled and this 'addBreadcrumb' call is a no-op.", new Object[0]);
        } else if (breadcrumb == null) {
            this.options.getLogger().log(SentryLevel.WARNING, "addBreadcrumb called with null parameter.", new Object[0]);
        } else {
            this.stack.peek().getScope().addBreadcrumb(breadcrumb, hint);
        }
    }

    @Override
    public void setLevel(@Nullable SentryLevel level) {
        if (!this.isEnabled()) {
            this.options.getLogger().log(SentryLevel.WARNING, "Instance is disabled and this 'setLevel' call is a no-op.", new Object[0]);
        } else {
            this.stack.peek().getScope().setLevel(level);
        }
    }

    @Override
    public void setTransaction(@Nullable String transaction) {
        if (!this.isEnabled()) {
            this.options.getLogger().log(SentryLevel.WARNING, "Instance is disabled and this 'setTransaction' call is a no-op.", new Object[0]);
        } else if (transaction != null) {
            this.stack.peek().getScope().setTransaction(transaction);
        } else {
            this.options.getLogger().log(SentryLevel.WARNING, "Transaction cannot be null", new Object[0]);
        }
    }

    @Override
    public void setUser(@Nullable User user) {
        if (!this.isEnabled()) {
            this.options.getLogger().log(SentryLevel.WARNING, "Instance is disabled and this 'setUser' call is a no-op.", new Object[0]);
        } else {
            this.stack.peek().getScope().setUser(user);
        }
    }

    @Override
    public void setFingerprint(@NotNull List<String> fingerprint) {
        if (!this.isEnabled()) {
            this.options.getLogger().log(SentryLevel.WARNING, "Instance is disabled and this 'setFingerprint' call is a no-op.", new Object[0]);
        } else if (fingerprint == null) {
            this.options.getLogger().log(SentryLevel.WARNING, "setFingerprint called with null parameter.", new Object[0]);
        } else {
            this.stack.peek().getScope().setFingerprint(fingerprint);
        }
    }

    @Override
    public void clearBreadcrumbs() {
        if (!this.isEnabled()) {
            this.options.getLogger().log(SentryLevel.WARNING, "Instance is disabled and this 'clearBreadcrumbs' call is a no-op.", new Object[0]);
        } else {
            this.stack.peek().getScope().clearBreadcrumbs();
        }
    }

    @Override
    public void setTag(@NotNull String key, @NotNull String value) {
        if (!this.isEnabled()) {
            this.options.getLogger().log(SentryLevel.WARNING, "Instance is disabled and this 'setTag' call is a no-op.", new Object[0]);
        } else if (key == null || value == null) {
            this.options.getLogger().log(SentryLevel.WARNING, "setTag called with null parameter.", new Object[0]);
        } else {
            this.stack.peek().getScope().setTag(key, value);
        }
    }

    @Override
    public void removeTag(@NotNull String key) {
        if (!this.isEnabled()) {
            this.options.getLogger().log(SentryLevel.WARNING, "Instance is disabled and this 'removeTag' call is a no-op.", new Object[0]);
        } else if (key == null) {
            this.options.getLogger().log(SentryLevel.WARNING, "removeTag called with null parameter.", new Object[0]);
        } else {
            this.stack.peek().getScope().removeTag(key);
        }
    }

    @Override
    public void setExtra(@NotNull String key, @NotNull String value) {
        if (!this.isEnabled()) {
            this.options.getLogger().log(SentryLevel.WARNING, "Instance is disabled and this 'setExtra' call is a no-op.", new Object[0]);
        } else if (key == null || value == null) {
            this.options.getLogger().log(SentryLevel.WARNING, "setExtra called with null parameter.", new Object[0]);
        } else {
            this.stack.peek().getScope().setExtra(key, value);
        }
    }

    @Override
    public void removeExtra(@NotNull String key) {
        if (!this.isEnabled()) {
            this.options.getLogger().log(SentryLevel.WARNING, "Instance is disabled and this 'removeExtra' call is a no-op.", new Object[0]);
        } else if (key == null) {
            this.options.getLogger().log(SentryLevel.WARNING, "removeExtra called with null parameter.", new Object[0]);
        } else {
            this.stack.peek().getScope().removeExtra(key);
        }
    }

    @Override
    @NotNull
    public SentryId getLastEventId() {
        return this.lastEventId;
    }

    @Override
    public void pushScope() {
        if (!this.isEnabled()) {
            this.options.getLogger().log(SentryLevel.WARNING, "Instance is disabled and this 'pushScope' call is a no-op.", new Object[0]);
        } else {
            Stack.StackItem item = this.stack.peek();
            Stack.StackItem newItem = new Stack.StackItem(this.options, item.getClient(), new Scope(item.getScope()));
            this.stack.push(newItem);
        }
    }

    @Override
    @NotNull
    public SentryOptions getOptions() {
        return this.stack.peek().getOptions();
    }

    @Override
    public void popScope() {
        if (!this.isEnabled()) {
            this.options.getLogger().log(SentryLevel.WARNING, "Instance is disabled and this 'popScope' call is a no-op.", new Object[0]);
        } else {
            this.stack.pop();
        }
    }

    @Override
    public void withScope(@NotNull ScopeCallback callback) {
        if (!this.isEnabled()) {
            this.options.getLogger().log(SentryLevel.WARNING, "Instance is disabled and this 'withScope' call is a no-op.", new Object[0]);
        } else {
            this.pushScope();
            try {
                callback.run(this.stack.peek().getScope());
            }
            catch (Exception e) {
                this.options.getLogger().log(SentryLevel.ERROR, "Error in the 'withScope' callback.", e);
            }
            this.popScope();
        }
    }

    @Override
    public void configureScope(@NotNull ScopeCallback callback) {
        if (!this.isEnabled()) {
            this.options.getLogger().log(SentryLevel.WARNING, "Instance is disabled and this 'configureScope' call is a no-op.", new Object[0]);
        } else {
            try {
                callback.run(this.stack.peek().getScope());
            }
            catch (Exception e) {
                this.options.getLogger().log(SentryLevel.ERROR, "Error in the 'configureScope' callback.", e);
            }
        }
    }

    @Override
    public void bindClient(@NotNull ISentryClient client) {
        if (!this.isEnabled()) {
            this.options.getLogger().log(SentryLevel.WARNING, "Instance is disabled and this 'bindClient' call is a no-op.", new Object[0]);
        } else {
            Stack.StackItem item = this.stack.peek();
            if (client != null) {
                this.options.getLogger().log(SentryLevel.DEBUG, "New client bound to scope.", new Object[0]);
                item.setClient(client);
            } else {
                this.options.getLogger().log(SentryLevel.DEBUG, "NoOp client bound to scope.", new Object[0]);
                item.setClient(NoOpSentryClient.getInstance());
            }
        }
    }

    @Override
    public void flush(long timeoutMillis) {
        if (!this.isEnabled()) {
            this.options.getLogger().log(SentryLevel.WARNING, "Instance is disabled and this 'flush' call is a no-op.", new Object[0]);
        } else {
            try {
                this.stack.peek().getClient().flush(timeoutMillis);
            }
            catch (Exception e) {
                this.options.getLogger().log(SentryLevel.ERROR, "Error in the 'client.flush'.", e);
            }
        }
    }

    @Override
    @NotNull
    public IHub clone() {
        if (!this.isEnabled()) {
            this.options.getLogger().log(SentryLevel.WARNING, "Disabled Hub cloned.", new Object[0]);
        }
        return new Hub(this.options, new Stack(this.stack));
    }

    @Override
    @ApiStatus.Internal
    @NotNull
    public SentryId captureTransaction(@NotNull SentryTransaction transaction, @Nullable Object hint) {
        Objects.requireNonNull(transaction, "transaction is required");
        SentryId sentryId = SentryId.EMPTY_ID;
        if (!this.isEnabled()) {
            this.options.getLogger().log(SentryLevel.WARNING, "Instance is disabled and this 'captureTransaction' call is a no-op.", new Object[0]);
        } else {
            if (!transaction.isFinished()) {
                this.options.getLogger().log(SentryLevel.WARNING, "Capturing unfinished transaction: %s", transaction.getEventId());
            }
            if (!Boolean.TRUE.equals(transaction.isSampled())) {
                this.options.getLogger().log(SentryLevel.DEBUG, "Transaction %s was dropped due to sampling decision.", transaction.getEventId());
            } else {
                Stack.StackItem item = null;
                try {
                    item = this.stack.peek();
                    sentryId = item.getClient().captureTransaction(transaction, item.getScope(), hint);
                }
                catch (Exception e) {
                    this.options.getLogger().log(SentryLevel.ERROR, "Error while capturing transaction with id: " + transaction.getEventId(), e);
                }
            }
        }
        this.lastEventId = sentryId;
        return sentryId;
    }

    @Override
    @NotNull
    public ITransaction startTransaction(@NotNull TransactionContext transactionContext, @Nullable CustomSamplingContext customSamplingContext, boolean bindToScope) {
        ITransaction transaction;
        Objects.requireNonNull(transactionContext, "transactionContext is required");
        if (!this.isEnabled()) {
            this.options.getLogger().log(SentryLevel.WARNING, "Instance is disabled and this 'startTransaction' returns a no-op.", new Object[0]);
            transaction = NoOpTransaction.getInstance();
        } else if (!this.options.isTracingEnabled()) {
            this.options.getLogger().log(SentryLevel.INFO, "Tracing is disabled and this 'startTransaction' returns a no-op.", new Object[0]);
            transaction = NoOpTransaction.getInstance();
        } else {
            SamplingContext samplingContext = new SamplingContext(transactionContext, customSamplingContext);
            boolean samplingDecision = this.tracesSampler.sample(samplingContext);
            transactionContext.setSampled(samplingDecision);
            transaction = new SentryTracer(transactionContext, this);
        }
        if (bindToScope) {
            this.configureScope(scope -> scope.setTransaction(transaction));
        }
        return transaction;
    }

    @Override
    @Nullable
    public SentryTraceHeader traceHeaders() {
        SentryTraceHeader traceHeader = null;
        if (!this.isEnabled()) {
            this.options.getLogger().log(SentryLevel.WARNING, "Instance is disabled and this 'traceHeaders' call is a no-op.", new Object[0]);
        } else {
            ISpan span = this.stack.peek().getScope().getSpan();
            if (span != null) {
                traceHeader = span.toSentryTrace();
            }
        }
        return traceHeader;
    }

    @Override
    @Nullable
    public ISpan getSpan() {
        ISpan span = null;
        if (!this.isEnabled()) {
            this.options.getLogger().log(SentryLevel.WARNING, "Instance is disabled and this 'getSpan' call is a no-op.", new Object[0]);
        } else {
            span = this.stack.peek().getScope().getSpan();
        }
        return span;
    }

    @Override
    @ApiStatus.Internal
    public void setSpanContext(@NotNull Throwable throwable, @NotNull ISpan span, @NotNull String transactionName) {
        Objects.requireNonNull(throwable, "throwable is required");
        Objects.requireNonNull(span, "span is required");
        Objects.requireNonNull(transactionName, "transactionName is required");
        Throwable rootCause = ExceptionUtils.findRootCause(throwable);
        if (!this.throwableToSpan.containsKey(rootCause)) {
            this.throwableToSpan.put(rootCause, new Pair<ISpan, String>(span, transactionName));
        }
    }

    @Nullable
    SpanContext getSpanContext(@NotNull Throwable throwable) {
        ISpan span;
        Objects.requireNonNull(throwable, "throwable is required");
        Throwable rootCause = ExceptionUtils.findRootCause(throwable);
        Pair<ISpan, String> pair = this.throwableToSpan.get(rootCause);
        if (pair != null && (span = pair.getFirst()) != null) {
            return span.getSpanContext();
        }
        return null;
    }
}

