/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.connectors.selectdb.config;

import java.util.Map;
import java.util.Properties;
import java.util.UUID;
import org.apache.seatunnel.api.configuration.Option;
import org.apache.seatunnel.api.configuration.Options;
import org.apache.seatunnel.common.config.CheckConfigUtil;
import org.apache.seatunnel.shade.com.typesafe.config.Config;

public class SelectDBConfig {
    private static final int DEFAULT_SINK_MAX_RETRIES = 3;
    private static final int DEFAULT_SINK_BUFFER_SIZE = 0xA00000;
    private static final int DEFAULT_SINK_BUFFER_COUNT = 10000;
    public static final Option<String> LOAD_URL = Options.key((String)"load-url").stringType().noDefaultValue().withDescription("SelectDB load http address.");
    public static final Option<String> JDBC_URL = Options.key((String)"jdbc-url").stringType().noDefaultValue().withDescription("SelectDB jdbc query address.");
    public static final Option<String> CLUSTER_NAME = Options.key((String)"cluster-name").stringType().noDefaultValue().withDescription("SelectDB cluster name.");
    public static final Option<String> TABLE_IDENTIFIER = Options.key((String)"table.identifier").stringType().noDefaultValue().withDescription("the jdbc table name.");
    public static final Option<String> USERNAME = Options.key((String)"username").stringType().noDefaultValue().withDescription("the jdbc user name.");
    public static final Option<String> PASSWORD = Options.key((String)"password").stringType().noDefaultValue().withDescription("the jdbc password.");
    public static final Option<Boolean> SINK_ENABLE_2PC = Options.key((String)"sink.enable-2pc").booleanType().defaultValue((Object)true).withDescription("enable 2PC while loading");
    public static final Option<Integer> SINK_MAX_RETRIES = Options.key((String)"sink.max-retries").intType().defaultValue((Object)3).withDescription("the max retry times if writing records to database failed.");
    public static final Option<Integer> SINK_BUFFER_SIZE = Options.key((String)"sink.buffer-size").intType().defaultValue((Object)0xA00000).withDescription("the buffer size to cache data for stream load.");
    public static final Option<Integer> SINK_BUFFER_COUNT = Options.key((String)"sink.buffer-count").intType().defaultValue((Object)10000).withDescription("the buffer count to cache data for stream load.");
    public static final Option<String> SINK_LABEL_PREFIX = Options.key((String)"sink.label-prefix").stringType().defaultValue((Object)UUID.randomUUID().toString()).withDescription("the unique label prefix.");
    public static final Option<Boolean> SINK_ENABLE_DELETE = Options.key((String)"sink.enable-delete").booleanType().defaultValue((Object)false).withDescription("whether to enable the delete function");
    public static final Option<Integer> SINK_FLUSH_QUEUE_SIZE = Options.key((String)"sink.flush.queue-size").intType().defaultValue((Object)1).withDescription("Queue length for async upload to object storage");
    public static final Option<Map<String, String>> SELECTDB_SINK_CONFIG_PREFIX = Options.key((String)"selectdb.config").mapType().noDefaultValue().withDescription("The parameter of the Copy Into data_desc. The way to specify the parameter is to add the prefix `selectdb.config` to the original load parameter name ");
    private String loadUrl;
    private String jdbcUrl;
    private String clusterName;
    private String username;
    private String password;
    private String tableIdentifier;
    private Boolean enableDelete;
    private String labelPrefix;
    private boolean enable2PC;
    private Integer maxRetries;
    private Integer bufferSize;
    private Integer bufferCount;
    private Integer flushQueueSize;
    private Properties StageLoadProps;

    public static SelectDBConfig loadConfig(Config pluginConfig) {
        SelectDBConfig selectdbConfig = new SelectDBConfig();
        selectdbConfig.setLoadUrl(pluginConfig.getString(LOAD_URL.key()));
        selectdbConfig.setJdbcUrl(pluginConfig.getString(JDBC_URL.key()));
        selectdbConfig.setClusterName(pluginConfig.getString(CLUSTER_NAME.key()));
        selectdbConfig.setUsername(pluginConfig.getString(USERNAME.key()));
        selectdbConfig.setPassword(pluginConfig.getString(PASSWORD.key()));
        selectdbConfig.setTableIdentifier(pluginConfig.getString(TABLE_IDENTIFIER.key()));
        selectdbConfig.setStageLoadProps(SelectDBConfig.parseCopyIntoProperties(pluginConfig));
        if (pluginConfig.hasPath(SINK_LABEL_PREFIX.key())) {
            selectdbConfig.setLabelPrefix(pluginConfig.getString(SINK_LABEL_PREFIX.key()));
        } else {
            selectdbConfig.setLabelPrefix((String)SINK_LABEL_PREFIX.defaultValue());
        }
        if (pluginConfig.hasPath(SINK_MAX_RETRIES.key())) {
            selectdbConfig.setMaxRetries(pluginConfig.getInt(SINK_MAX_RETRIES.key()));
        } else {
            selectdbConfig.setMaxRetries((Integer)SINK_MAX_RETRIES.defaultValue());
        }
        if (pluginConfig.hasPath(SINK_ENABLE_2PC.key())) {
            selectdbConfig.setEnable2PC(pluginConfig.getBoolean(SINK_ENABLE_2PC.key()));
        } else {
            selectdbConfig.setEnable2PC((Boolean)SINK_ENABLE_2PC.defaultValue());
        }
        if (pluginConfig.hasPath(SINK_BUFFER_SIZE.key())) {
            selectdbConfig.setBufferSize(pluginConfig.getInt(SINK_BUFFER_SIZE.key()));
        } else {
            selectdbConfig.setBufferSize((Integer)SINK_BUFFER_SIZE.defaultValue());
        }
        if (pluginConfig.hasPath(SINK_BUFFER_COUNT.key())) {
            selectdbConfig.setBufferCount(pluginConfig.getInt(SINK_BUFFER_COUNT.key()));
        } else {
            selectdbConfig.setBufferCount((Integer)SINK_BUFFER_COUNT.defaultValue());
        }
        if (pluginConfig.hasPath(SINK_ENABLE_DELETE.key())) {
            selectdbConfig.setEnableDelete(pluginConfig.getBoolean(SINK_ENABLE_DELETE.key()));
        } else {
            selectdbConfig.setEnableDelete((Boolean)SINK_ENABLE_DELETE.defaultValue());
        }
        if (pluginConfig.hasPath(SINK_FLUSH_QUEUE_SIZE.key())) {
            selectdbConfig.setFlushQueueSize(pluginConfig.getInt(SINK_FLUSH_QUEUE_SIZE.key()));
        } else {
            selectdbConfig.setFlushQueueSize((Integer)SINK_FLUSH_QUEUE_SIZE.defaultValue());
        }
        return selectdbConfig;
    }

    private static Properties parseCopyIntoProperties(Config pluginConfig) {
        Properties stageLoadProps = new Properties();
        if (CheckConfigUtil.isValidParam((Config)pluginConfig, (String)SELECTDB_SINK_CONFIG_PREFIX.key())) {
            pluginConfig.getObject(SELECTDB_SINK_CONFIG_PREFIX.key()).forEach((key, value) -> {
                String configKey = key.toLowerCase();
                stageLoadProps.put(configKey, value.unwrapped().toString());
            });
        }
        return stageLoadProps;
    }

    public void setLoadUrl(String loadUrl) {
        this.loadUrl = loadUrl;
    }

    public void setJdbcUrl(String jdbcUrl) {
        this.jdbcUrl = jdbcUrl;
    }

    public void setClusterName(String clusterName) {
        this.clusterName = clusterName;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public void setTableIdentifier(String tableIdentifier) {
        this.tableIdentifier = tableIdentifier;
    }

    public void setEnableDelete(Boolean enableDelete) {
        this.enableDelete = enableDelete;
    }

    public void setLabelPrefix(String labelPrefix) {
        this.labelPrefix = labelPrefix;
    }

    public void setEnable2PC(boolean enable2PC) {
        this.enable2PC = enable2PC;
    }

    public void setMaxRetries(Integer maxRetries) {
        this.maxRetries = maxRetries;
    }

    public void setBufferSize(Integer bufferSize) {
        this.bufferSize = bufferSize;
    }

    public void setBufferCount(Integer bufferCount) {
        this.bufferCount = bufferCount;
    }

    public void setFlushQueueSize(Integer flushQueueSize) {
        this.flushQueueSize = flushQueueSize;
    }

    public void setStageLoadProps(Properties StageLoadProps) {
        this.StageLoadProps = StageLoadProps;
    }

    public String getLoadUrl() {
        return this.loadUrl;
    }

    public String getJdbcUrl() {
        return this.jdbcUrl;
    }

    public String getClusterName() {
        return this.clusterName;
    }

    public String getUsername() {
        return this.username;
    }

    public String getPassword() {
        return this.password;
    }

    public String getTableIdentifier() {
        return this.tableIdentifier;
    }

    public Boolean getEnableDelete() {
        return this.enableDelete;
    }

    public String getLabelPrefix() {
        return this.labelPrefix;
    }

    public boolean isEnable2PC() {
        return this.enable2PC;
    }

    public Integer getMaxRetries() {
        return this.maxRetries;
    }

    public Integer getBufferSize() {
        return this.bufferSize;
    }

    public Integer getBufferCount() {
        return this.bufferCount;
    }

    public Integer getFlushQueueSize() {
        return this.flushQueueSize;
    }

    public Properties getStageLoadProps() {
        return this.StageLoadProps;
    }

    public String toString() {
        return "SelectDBConfig(loadUrl=" + this.getLoadUrl() + ", jdbcUrl=" + this.getJdbcUrl() + ", clusterName=" + this.getClusterName() + ", username=" + this.getUsername() + ", password=" + this.getPassword() + ", tableIdentifier=" + this.getTableIdentifier() + ", enableDelete=" + this.getEnableDelete() + ", labelPrefix=" + this.getLabelPrefix() + ", enable2PC=" + this.isEnable2PC() + ", maxRetries=" + this.getMaxRetries() + ", bufferSize=" + this.getBufferSize() + ", bufferCount=" + this.getBufferCount() + ", flushQueueSize=" + this.getFlushQueueSize() + ", StageLoadProps=" + this.getStageLoadProps() + ")";
    }
}

