/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.connectors.seatunnel.rocketmq.sink;

import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.apache.rocketmq.common.message.Message;
import org.apache.seatunnel.api.table.type.SeaTunnelRow;
import org.apache.seatunnel.api.table.type.SeaTunnelRowType;
import org.apache.seatunnel.common.exception.CommonErrorCodeDeprecated;
import org.apache.seatunnel.common.exception.SeaTunnelErrorCode;
import org.apache.seatunnel.connectors.seatunnel.common.sink.AbstractSinkWriter;
import org.apache.seatunnel.connectors.seatunnel.rocketmq.exception.RocketMqConnectorException;
import org.apache.seatunnel.connectors.seatunnel.rocketmq.serialize.DefaultSeaTunnelRowSerializer;
import org.apache.seatunnel.connectors.seatunnel.rocketmq.serialize.SeaTunnelRowSerializer;
import org.apache.seatunnel.connectors.seatunnel.rocketmq.sink.ProducerMetadata;
import org.apache.seatunnel.connectors.seatunnel.rocketmq.sink.RocketMqNoTransactionSender;
import org.apache.seatunnel.connectors.seatunnel.rocketmq.sink.RocketMqProducerSender;
import org.apache.seatunnel.connectors.seatunnel.rocketmq.sink.RocketMqTransactionSender;

public class RocketMqSinkWriter
extends AbstractSinkWriter<SeaTunnelRow, Void> {
    private final ProducerMetadata producerMetadata;
    private final SeaTunnelRowSerializer seaTunnelRowSerializer;
    private final RocketMqProducerSender rocketMqProducerSender;

    public RocketMqSinkWriter(ProducerMetadata producerMetadata, SeaTunnelRowType seaTunnelRowType) {
        this.producerMetadata = producerMetadata;
        this.seaTunnelRowSerializer = this.getSerializer(seaTunnelRowType);
        this.rocketMqProducerSender = producerMetadata.isExactlyOnce() ? new RocketMqTransactionSender(producerMetadata.getConfiguration()) : new RocketMqNoTransactionSender(producerMetadata.getConfiguration(), producerMetadata.isSync());
        System.setProperty("rocketmq.client.logUseSlf4j", "true");
    }

    public void write(SeaTunnelRow element) throws IOException {
        Message message = this.seaTunnelRowSerializer.serializeRow(element);
        this.rocketMqProducerSender.send(message);
    }

    public void close() throws IOException {
        if (this.rocketMqProducerSender != null) {
            try {
                this.rocketMqProducerSender.close();
            }
            catch (Exception e) {
                throw new RocketMqConnectorException((SeaTunnelErrorCode)CommonErrorCodeDeprecated.WRITER_OPERATION_FAILED, "Close RocketMq sink writer error", e);
            }
        }
    }

    private SeaTunnelRowSerializer<byte[], byte[]> getSerializer(SeaTunnelRowType seaTunnelRowType) {
        return new DefaultSeaTunnelRowSerializer(this.producerMetadata.getTopic(), this.producerMetadata.getTag(), this.getPartitionKeyFields(seaTunnelRowType), seaTunnelRowType, this.producerMetadata.getFormat(), this.producerMetadata.getFieldDelimiter());
    }

    private List<String> getPartitionKeyFields(SeaTunnelRowType seaTunnelRowType) {
        if (this.producerMetadata.getPartitionKeyFields() == null) {
            return Collections.emptyList();
        }
        List<String> partitionKeyFields = this.producerMetadata.getPartitionKeyFields();
        List<String> rowTypeFieldNames = Arrays.asList(seaTunnelRowType.getFieldNames());
        for (String partitionKeyField : partitionKeyFields) {
            if (rowTypeFieldNames.contains(partitionKeyField)) continue;
            throw new RocketMqConnectorException((SeaTunnelErrorCode)CommonErrorCodeDeprecated.ILLEGAL_ARGUMENT, String.format("Partition key field not found: %s, rowType: %s", partitionKeyField, rowTypeFieldNames));
        }
        return partitionKeyFields;
    }
}

