/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.client.consumer.rebalance;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.apache.commons.lang3.StringUtils;
import org.apache.rocketmq.client.consumer.AllocateMessageQueueStrategy;
import org.apache.rocketmq.client.consumer.rebalance.AbstractAllocateMessageQueueStrategy;
import org.apache.rocketmq.common.message.MessageQueue;

public class AllocateMachineRoomNearby
extends AbstractAllocateMessageQueueStrategy {
    private final AllocateMessageQueueStrategy allocateMessageQueueStrategy;
    private final MachineRoomResolver machineRoomResolver;

    public AllocateMachineRoomNearby(AllocateMessageQueueStrategy allocateMessageQueueStrategy, MachineRoomResolver machineRoomResolver) throws NullPointerException {
        if (allocateMessageQueueStrategy == null) {
            throw new NullPointerException("allocateMessageQueueStrategy is null");
        }
        if (machineRoomResolver == null) {
            throw new NullPointerException("machineRoomResolver is null");
        }
        this.allocateMessageQueueStrategy = allocateMessageQueueStrategy;
        this.machineRoomResolver = machineRoomResolver;
    }

    @Override
    public List<MessageQueue> allocate(String consumerGroup, String currentCID, List<MessageQueue> mqAll, List<String> cidAll) {
        ArrayList<MessageQueue> result = new ArrayList<MessageQueue>();
        if (!this.check(consumerGroup, currentCID, mqAll, cidAll)) {
            return result;
        }
        TreeMap mr2Mq = new TreeMap();
        for (MessageQueue messageQueue : mqAll) {
            String brokerMachineRoom = this.machineRoomResolver.brokerDeployIn(messageQueue);
            if (StringUtils.isNoneEmpty(brokerMachineRoom)) {
                if (mr2Mq.get(brokerMachineRoom) == null) {
                    mr2Mq.put(brokerMachineRoom, new ArrayList());
                }
                ((List)mr2Mq.get(brokerMachineRoom)).add(messageQueue);
                continue;
            }
            throw new IllegalArgumentException("Machine room is null for mq " + messageQueue);
        }
        TreeMap mr2c = new TreeMap();
        for (String cid : cidAll) {
            String consumerMachineRoom = this.machineRoomResolver.consumerDeployIn(cid);
            if (StringUtils.isNoneEmpty(consumerMachineRoom)) {
                if (mr2c.get(consumerMachineRoom) == null) {
                    mr2c.put(consumerMachineRoom, new ArrayList());
                }
                ((List)mr2c.get(consumerMachineRoom)).add(cid);
                continue;
            }
            throw new IllegalArgumentException("Machine room is null for consumer id " + cid);
        }
        ArrayList<MessageQueue> arrayList = new ArrayList<MessageQueue>();
        String currentMachineRoom = this.machineRoomResolver.consumerDeployIn(currentCID);
        List mqInThisMachineRoom = (List)mr2Mq.remove(currentMachineRoom);
        List consumerInThisMachineRoom = (List)mr2c.get(currentMachineRoom);
        if (mqInThisMachineRoom != null && !mqInThisMachineRoom.isEmpty()) {
            arrayList.addAll(this.allocateMessageQueueStrategy.allocate(consumerGroup, currentCID, mqInThisMachineRoom, consumerInThisMachineRoom));
        }
        for (Map.Entry machineRoomEntry : mr2Mq.entrySet()) {
            if (mr2c.containsKey(machineRoomEntry.getKey())) continue;
            arrayList.addAll(this.allocateMessageQueueStrategy.allocate(consumerGroup, currentCID, (List)machineRoomEntry.getValue(), cidAll));
        }
        return arrayList;
    }

    @Override
    public String getName() {
        return "MACHINE_ROOM_NEARBY-" + this.allocateMessageQueueStrategy.getName();
    }

    public static interface MachineRoomResolver {
        public String brokerDeployIn(MessageQueue var1);

        public String consumerDeployIn(String var1);
    }
}

