/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.connectors.seatunnel.redis.source;

import com.google.auto.service.AutoService;
import java.io.Serializable;
import org.apache.seatunnel.api.configuration.Option;
import org.apache.seatunnel.api.configuration.util.OptionRule;
import org.apache.seatunnel.api.options.SinkConnectorCommonOptions;
import org.apache.seatunnel.api.source.SeaTunnelSource;
import org.apache.seatunnel.api.source.SourceSplit;
import org.apache.seatunnel.api.table.connector.TableSource;
import org.apache.seatunnel.api.table.factory.Factory;
import org.apache.seatunnel.api.table.factory.TableSourceFactory;
import org.apache.seatunnel.api.table.factory.TableSourceFactoryContext;
import org.apache.seatunnel.connectors.seatunnel.redis.config.RedisBaseOptions;
import org.apache.seatunnel.connectors.seatunnel.redis.config.RedisSourceOptions;
import org.apache.seatunnel.connectors.seatunnel.redis.source.RedisSource;

@AutoService(value={Factory.class})
public class RedisSourceFactory
implements TableSourceFactory {
    public String factoryIdentifier() {
        return "Redis";
    }

    public <T, SplitT extends SourceSplit, StateT extends Serializable> TableSource<T, SplitT, StateT> createSource(TableSourceFactoryContext context) {
        return () -> new RedisSource(context.getOptions());
    }

    public OptionRule optionRule() {
        return OptionRule.builder().required(new Option[]{RedisBaseOptions.KEY_PATTERN, RedisBaseOptions.DATA_TYPE}).optional(new Option[]{RedisBaseOptions.MODE, RedisSourceOptions.HASH_KEY_PARSE_MODE, RedisBaseOptions.AUTH, RedisBaseOptions.USER, RedisBaseOptions.KEY}).conditional(RedisBaseOptions.MODE, (Object)RedisBaseOptions.RedisMode.CLUSTER, new Option[]{RedisBaseOptions.NODES}).conditional(RedisBaseOptions.MODE, (Object)RedisBaseOptions.RedisMode.SINGLE, new Option[]{RedisBaseOptions.HOST, RedisBaseOptions.PORT}).bundled(new Option[]{RedisBaseOptions.FORMAT, SinkConnectorCommonOptions.SCHEMA}).build();
    }

    public Class<? extends SeaTunnelSource> getSourceClass() {
        return RedisSource.class;
    }
}

