/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.connectors.seatunnel.redis.sink;

import com.google.auto.service.AutoService;
import org.apache.seatunnel.api.configuration.Option;
import org.apache.seatunnel.api.configuration.util.OptionRule;
import org.apache.seatunnel.api.options.SinkConnectorCommonOptions;
import org.apache.seatunnel.api.table.catalog.CatalogTable;
import org.apache.seatunnel.api.table.connector.TableSink;
import org.apache.seatunnel.api.table.factory.Factory;
import org.apache.seatunnel.api.table.factory.TableSinkFactory;
import org.apache.seatunnel.api.table.factory.TableSinkFactoryContext;
import org.apache.seatunnel.connectors.seatunnel.redis.config.RedisBaseOptions;
import org.apache.seatunnel.connectors.seatunnel.redis.config.RedisSinkOptions;
import org.apache.seatunnel.connectors.seatunnel.redis.sink.RedisSink;

@AutoService(value={Factory.class})
public class RedisSinkFactory
implements TableSinkFactory {
    public String factoryIdentifier() {
        return "Redis";
    }

    public TableSink createSink(TableSinkFactoryContext context) {
        CatalogTable catalogTable = context.getCatalogTable();
        return () -> new RedisSink(context.getOptions(), catalogTable);
    }

    public OptionRule optionRule() {
        return OptionRule.builder().required(new Option[]{RedisBaseOptions.KEY, RedisBaseOptions.DATA_TYPE}).optional(new Option[]{RedisBaseOptions.MODE, RedisBaseOptions.AUTH, RedisBaseOptions.USER, RedisBaseOptions.KEY_PATTERN, RedisBaseOptions.FORMAT, RedisSinkOptions.EXPIRE, RedisSinkOptions.SUPPORT_CUSTOM_KEY, RedisSinkOptions.VALUE_FIELD, RedisSinkOptions.HASH_KEY_FIELD, RedisSinkOptions.HASH_VALUE_FIELD, SinkConnectorCommonOptions.MULTI_TABLE_SINK_REPLICA}).conditional(RedisBaseOptions.MODE, (Object)RedisBaseOptions.RedisMode.SINGLE, new Option[]{RedisBaseOptions.HOST, RedisBaseOptions.PORT}).conditional(RedisBaseOptions.MODE, (Object)RedisBaseOptions.RedisMode.CLUSTER, new Option[]{RedisBaseOptions.NODES}).build();
    }
}

