/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.connectors.seatunnel.redis.config;

import java.io.Serializable;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.pool2.impl.GenericObjectPoolConfig;
import org.apache.logging.log4j.core.util.Assert;
import org.apache.seatunnel.api.configuration.ReadonlyConfig;
import org.apache.seatunnel.common.exception.CommonErrorCode;
import org.apache.seatunnel.common.exception.SeaTunnelErrorCode;
import org.apache.seatunnel.connectors.seatunnel.redis.client.RedisClient;
import org.apache.seatunnel.connectors.seatunnel.redis.client.RedisClusterClient;
import org.apache.seatunnel.connectors.seatunnel.redis.client.RedisSingleClient;
import org.apache.seatunnel.connectors.seatunnel.redis.config.JedisWrapper;
import org.apache.seatunnel.connectors.seatunnel.redis.config.RedisBaseOptions;
import org.apache.seatunnel.connectors.seatunnel.redis.config.RedisDataType;
import org.apache.seatunnel.connectors.seatunnel.redis.config.RedisSinkOptions;
import org.apache.seatunnel.connectors.seatunnel.redis.config.RedisSourceOptions;
import org.apache.seatunnel.connectors.seatunnel.redis.exception.RedisConnectorException;
import org.apache.seatunnel.connectors.seatunnel.redis.exception.RedisErrorCode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import redis.clients.jedis.Connection;
import redis.clients.jedis.ConnectionPoolConfig;
import redis.clients.jedis.HostAndPort;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.JedisCluster;

public class RedisParameters
implements Serializable {
    private static final Logger log = LoggerFactory.getLogger(RedisParameters.class);
    private String host;
    private Integer port;
    private String auth = "";
    private int dbNum;
    private String user = "";
    private String keysPattern;
    private String keyField;
    private RedisDataType redisDataType;
    private RedisBaseOptions.RedisMode mode;
    private RedisSourceOptions.HashKeyParseMode hashKeyParseMode;
    private List<String> redisNodes = Collections.emptyList();
    private long expire = (Long)RedisSinkOptions.EXPIRE.defaultValue();
    private int batchSize = (Integer)RedisBaseOptions.BATCH_SIZE.defaultValue();
    private Boolean supportCustomKey;
    private String valueField;
    private String hashKeyField;
    private String hashValueField;
    private int redisVersion;

    public void buildWithConfig(ReadonlyConfig config) {
        this.host = (String)config.get(RedisBaseOptions.HOST);
        this.port = (Integer)config.get(RedisBaseOptions.PORT);
        this.dbNum = (Integer)config.get(RedisBaseOptions.DB_NUM);
        this.hashKeyParseMode = (RedisSourceOptions.HashKeyParseMode)((Object)config.get(RedisSourceOptions.HASH_KEY_PARSE_MODE));
        this.expire = (Long)config.get(RedisSinkOptions.EXPIRE);
        if (config.getOptional(RedisBaseOptions.AUTH).isPresent()) {
            this.auth = (String)config.get(RedisBaseOptions.AUTH);
        }
        if (config.getOptional(RedisBaseOptions.USER).isPresent()) {
            this.user = (String)config.get(RedisBaseOptions.USER);
        }
        this.mode = (RedisBaseOptions.RedisMode)((Object)config.get(RedisBaseOptions.MODE));
        if (config.getOptional(RedisBaseOptions.NODES).isPresent()) {
            this.redisNodes = (List)config.get(RedisBaseOptions.NODES);
        }
        if (config.getOptional(RedisBaseOptions.KEY).isPresent()) {
            this.keyField = (String)config.get(RedisBaseOptions.KEY);
        }
        if (config.getOptional(RedisBaseOptions.KEY_PATTERN).isPresent()) {
            this.keysPattern = (String)config.get(RedisBaseOptions.KEY_PATTERN);
        }
        this.redisDataType = (RedisDataType)((Object)config.get(RedisBaseOptions.DATA_TYPE));
        this.batchSize = (Integer)config.get(RedisBaseOptions.BATCH_SIZE);
        if (config.getOptional(RedisSinkOptions.SUPPORT_CUSTOM_KEY).isPresent()) {
            this.supportCustomKey = (Boolean)config.get(RedisSinkOptions.SUPPORT_CUSTOM_KEY);
        }
        if (config.getOptional(RedisSinkOptions.VALUE_FIELD).isPresent()) {
            this.valueField = (String)config.get(RedisSinkOptions.VALUE_FIELD);
        }
        if (config.getOptional(RedisSinkOptions.HASH_KEY_FIELD).isPresent()) {
            this.hashKeyField = (String)config.get(RedisSinkOptions.HASH_KEY_FIELD);
        }
        if (config.getOptional(RedisSinkOptions.HASH_VALUE_FIELD).isPresent()) {
            this.hashValueField = (String)config.get(RedisSinkOptions.HASH_VALUE_FIELD);
        }
    }

    public RedisClient buildRedisClient() {
        Jedis jedis = this.buildJedis();
        this.redisVersion = this.extractRedisVersion(jedis);
        if (this.mode.equals((Object)RedisBaseOptions.RedisMode.SINGLE)) {
            return new RedisSingleClient(this, jedis, this.redisVersion);
        }
        return new RedisClusterClient(this, jedis, this.redisVersion);
    }

    private int extractRedisVersion(Jedis jedis) {
        log.info("Try to get redis version information from the jedis.info() method");
        String info = jedis.info();
        try {
            for (String line : info.split("\n")) {
                if (!line.startsWith("redis_version:")) continue;
                String versionInfo = line.split(":")[1].trim();
                log.info("The version of Redis is :{}", (Object)versionInfo);
                String[] parts = versionInfo.split("\\.");
                return Integer.parseInt(parts[0]);
            }
        }
        catch (Exception e) {
            throw new RedisConnectorException(RedisErrorCode.GET_REDIS_VERSION_INFO_FAILED, RedisErrorCode.GET_REDIS_VERSION_INFO_FAILED.getErrorMessage(), e);
        }
        throw new RedisConnectorException((SeaTunnelErrorCode)RedisErrorCode.GET_REDIS_VERSION_INFO_FAILED, "Did not get the expected redis_version from the jedis.info() method");
    }

    public Jedis buildJedis() {
        switch (this.mode) {
            case SINGLE: {
                Jedis jedis = new Jedis(this.host, (int)this.port);
                if (StringUtils.isNotBlank((CharSequence)this.auth)) {
                    jedis.auth(this.auth);
                }
                if (StringUtils.isNotBlank((CharSequence)this.user)) {
                    jedis.aclSetUser(this.user);
                }
                jedis.select(this.dbNum);
                return jedis;
            }
            case CLUSTER: {
                HashSet<HostAndPort> nodes = new HashSet<HostAndPort>();
                Assert.requireNonEmpty(this.redisNodes, (String)"nodes parameter must not be empty");
                for (String redisNode : this.redisNodes) {
                    String[] splits = redisNode.split(":");
                    if (splits.length != 2) {
                        throw new RedisConnectorException((SeaTunnelErrorCode)RedisErrorCode.INVALID_CONFIG, "Invalid redis node information,redis node information must like as the following: [host:port]");
                    }
                    HostAndPort hostAndPort = new HostAndPort(splits[0], Integer.parseInt(splits[1]));
                    nodes.add(hostAndPort);
                }
                ConnectionPoolConfig connectionPoolConfig = new ConnectionPoolConfig();
                JedisCluster jedisCluster = StringUtils.isNotBlank((CharSequence)this.auth) ? new JedisCluster(nodes, 2000, 2000, 5, this.auth, (GenericObjectPoolConfig<Connection>)connectionPoolConfig) : new JedisCluster(nodes);
                JedisWrapper jedisWrapper = new JedisWrapper(jedisCluster);
                jedisWrapper.select(this.dbNum);
                return jedisWrapper;
            }
        }
        throw new RedisConnectorException((SeaTunnelErrorCode)CommonErrorCode.OPERATION_NOT_SUPPORTED, "Not support this redis mode");
    }

    public String getHost() {
        return this.host;
    }

    public Integer getPort() {
        return this.port;
    }

    public String getAuth() {
        return this.auth;
    }

    public int getDbNum() {
        return this.dbNum;
    }

    public String getUser() {
        return this.user;
    }

    public String getKeysPattern() {
        return this.keysPattern;
    }

    public String getKeyField() {
        return this.keyField;
    }

    public RedisDataType getRedisDataType() {
        return this.redisDataType;
    }

    public RedisBaseOptions.RedisMode getMode() {
        return this.mode;
    }

    public RedisSourceOptions.HashKeyParseMode getHashKeyParseMode() {
        return this.hashKeyParseMode;
    }

    public List<String> getRedisNodes() {
        return this.redisNodes;
    }

    public long getExpire() {
        return this.expire;
    }

    public int getBatchSize() {
        return this.batchSize;
    }

    public Boolean getSupportCustomKey() {
        return this.supportCustomKey;
    }

    public String getValueField() {
        return this.valueField;
    }

    public String getHashKeyField() {
        return this.hashKeyField;
    }

    public String getHashValueField() {
        return this.hashValueField;
    }

    public int getRedisVersion() {
        return this.redisVersion;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public void setPort(Integer port) {
        this.port = port;
    }

    public void setAuth(String auth) {
        this.auth = auth;
    }

    public void setDbNum(int dbNum) {
        this.dbNum = dbNum;
    }

    public void setUser(String user) {
        this.user = user;
    }

    public void setKeysPattern(String keysPattern) {
        this.keysPattern = keysPattern;
    }

    public void setKeyField(String keyField) {
        this.keyField = keyField;
    }

    public void setRedisDataType(RedisDataType redisDataType) {
        this.redisDataType = redisDataType;
    }

    public void setMode(RedisBaseOptions.RedisMode mode) {
        this.mode = mode;
    }

    public void setHashKeyParseMode(RedisSourceOptions.HashKeyParseMode hashKeyParseMode) {
        this.hashKeyParseMode = hashKeyParseMode;
    }

    public void setRedisNodes(List<String> redisNodes) {
        this.redisNodes = redisNodes;
    }

    public void setExpire(long expire) {
        this.expire = expire;
    }

    public void setBatchSize(int batchSize) {
        this.batchSize = batchSize;
    }

    public void setSupportCustomKey(Boolean supportCustomKey) {
        this.supportCustomKey = supportCustomKey;
    }

    public void setValueField(String valueField) {
        this.valueField = valueField;
    }

    public void setHashKeyField(String hashKeyField) {
        this.hashKeyField = hashKeyField;
    }

    public void setHashValueField(String hashValueField) {
        this.hashValueField = hashValueField;
    }

    public void setRedisVersion(int redisVersion) {
        this.redisVersion = redisVersion;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RedisParameters)) {
            return false;
        }
        RedisParameters other = (RedisParameters)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getDbNum() != other.getDbNum()) {
            return false;
        }
        if (this.getExpire() != other.getExpire()) {
            return false;
        }
        if (this.getBatchSize() != other.getBatchSize()) {
            return false;
        }
        if (this.getRedisVersion() != other.getRedisVersion()) {
            return false;
        }
        Integer this$port = this.getPort();
        Integer other$port = other.getPort();
        if (this$port == null ? other$port != null : !((Object)this$port).equals(other$port)) {
            return false;
        }
        Boolean this$supportCustomKey = this.getSupportCustomKey();
        Boolean other$supportCustomKey = other.getSupportCustomKey();
        if (this$supportCustomKey == null ? other$supportCustomKey != null : !((Object)this$supportCustomKey).equals(other$supportCustomKey)) {
            return false;
        }
        String this$host = this.getHost();
        String other$host = other.getHost();
        if (this$host == null ? other$host != null : !this$host.equals(other$host)) {
            return false;
        }
        String this$auth = this.getAuth();
        String other$auth = other.getAuth();
        if (this$auth == null ? other$auth != null : !this$auth.equals(other$auth)) {
            return false;
        }
        String this$user = this.getUser();
        String other$user = other.getUser();
        if (this$user == null ? other$user != null : !this$user.equals(other$user)) {
            return false;
        }
        String this$keysPattern = this.getKeysPattern();
        String other$keysPattern = other.getKeysPattern();
        if (this$keysPattern == null ? other$keysPattern != null : !this$keysPattern.equals(other$keysPattern)) {
            return false;
        }
        String this$keyField = this.getKeyField();
        String other$keyField = other.getKeyField();
        if (this$keyField == null ? other$keyField != null : !this$keyField.equals(other$keyField)) {
            return false;
        }
        RedisDataType this$redisDataType = this.getRedisDataType();
        RedisDataType other$redisDataType = other.getRedisDataType();
        if (this$redisDataType == null ? other$redisDataType != null : !((Object)((Object)this$redisDataType)).equals((Object)other$redisDataType)) {
            return false;
        }
        RedisBaseOptions.RedisMode this$mode = this.getMode();
        RedisBaseOptions.RedisMode other$mode = other.getMode();
        if (this$mode == null ? other$mode != null : !((Object)((Object)this$mode)).equals((Object)other$mode)) {
            return false;
        }
        RedisSourceOptions.HashKeyParseMode this$hashKeyParseMode = this.getHashKeyParseMode();
        RedisSourceOptions.HashKeyParseMode other$hashKeyParseMode = other.getHashKeyParseMode();
        if (this$hashKeyParseMode == null ? other$hashKeyParseMode != null : !((Object)((Object)this$hashKeyParseMode)).equals((Object)other$hashKeyParseMode)) {
            return false;
        }
        List<String> this$redisNodes = this.getRedisNodes();
        List<String> other$redisNodes = other.getRedisNodes();
        if (this$redisNodes == null ? other$redisNodes != null : !((Object)this$redisNodes).equals(other$redisNodes)) {
            return false;
        }
        String this$valueField = this.getValueField();
        String other$valueField = other.getValueField();
        if (this$valueField == null ? other$valueField != null : !this$valueField.equals(other$valueField)) {
            return false;
        }
        String this$hashKeyField = this.getHashKeyField();
        String other$hashKeyField = other.getHashKeyField();
        if (this$hashKeyField == null ? other$hashKeyField != null : !this$hashKeyField.equals(other$hashKeyField)) {
            return false;
        }
        String this$hashValueField = this.getHashValueField();
        String other$hashValueField = other.getHashValueField();
        return !(this$hashValueField == null ? other$hashValueField != null : !this$hashValueField.equals(other$hashValueField));
    }

    protected boolean canEqual(Object other) {
        return other instanceof RedisParameters;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getDbNum();
        long $expire = this.getExpire();
        result = result * 59 + (int)($expire >>> 32 ^ $expire);
        result = result * 59 + this.getBatchSize();
        result = result * 59 + this.getRedisVersion();
        Integer $port = this.getPort();
        result = result * 59 + ($port == null ? 43 : ((Object)$port).hashCode());
        Boolean $supportCustomKey = this.getSupportCustomKey();
        result = result * 59 + ($supportCustomKey == null ? 43 : ((Object)$supportCustomKey).hashCode());
        String $host = this.getHost();
        result = result * 59 + ($host == null ? 43 : $host.hashCode());
        String $auth = this.getAuth();
        result = result * 59 + ($auth == null ? 43 : $auth.hashCode());
        String $user = this.getUser();
        result = result * 59 + ($user == null ? 43 : $user.hashCode());
        String $keysPattern = this.getKeysPattern();
        result = result * 59 + ($keysPattern == null ? 43 : $keysPattern.hashCode());
        String $keyField = this.getKeyField();
        result = result * 59 + ($keyField == null ? 43 : $keyField.hashCode());
        RedisDataType $redisDataType = this.getRedisDataType();
        result = result * 59 + ($redisDataType == null ? 43 : ((Object)((Object)$redisDataType)).hashCode());
        RedisBaseOptions.RedisMode $mode = this.getMode();
        result = result * 59 + ($mode == null ? 43 : ((Object)((Object)$mode)).hashCode());
        RedisSourceOptions.HashKeyParseMode $hashKeyParseMode = this.getHashKeyParseMode();
        result = result * 59 + ($hashKeyParseMode == null ? 43 : ((Object)((Object)$hashKeyParseMode)).hashCode());
        List<String> $redisNodes = this.getRedisNodes();
        result = result * 59 + ($redisNodes == null ? 43 : ((Object)$redisNodes).hashCode());
        String $valueField = this.getValueField();
        result = result * 59 + ($valueField == null ? 43 : $valueField.hashCode());
        String $hashKeyField = this.getHashKeyField();
        result = result * 59 + ($hashKeyField == null ? 43 : $hashKeyField.hashCode());
        String $hashValueField = this.getHashValueField();
        result = result * 59 + ($hashValueField == null ? 43 : $hashValueField.hashCode());
        return result;
    }

    public String toString() {
        return "RedisParameters(host=" + this.getHost() + ", port=" + this.getPort() + ", auth=" + this.getAuth() + ", dbNum=" + this.getDbNum() + ", user=" + this.getUser() + ", keysPattern=" + this.getKeysPattern() + ", keyField=" + this.getKeyField() + ", redisDataType=" + (Object)((Object)this.getRedisDataType()) + ", mode=" + (Object)((Object)this.getMode()) + ", hashKeyParseMode=" + (Object)((Object)this.getHashKeyParseMode()) + ", redisNodes=" + this.getRedisNodes() + ", expire=" + this.getExpire() + ", batchSize=" + this.getBatchSize() + ", supportCustomKey=" + this.getSupportCustomKey() + ", valueField=" + this.getValueField() + ", hashKeyField=" + this.getHashKeyField() + ", hashValueField=" + this.getHashValueField() + ", redisVersion=" + this.getRedisVersion() + ")";
    }
}

