/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.connectors.seatunnel.redis.client;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.seatunnel.api.table.type.RowKind;
import org.apache.seatunnel.connectors.seatunnel.redis.config.RedisDataType;
import org.apache.seatunnel.connectors.seatunnel.redis.config.RedisParameters;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.params.ScanParams;
import redis.clients.jedis.resps.ScanResult;

public abstract class RedisClient
extends Jedis {
    protected final RedisParameters redisParameters;
    private final Integer redisVersion;
    protected final int batchSize;
    protected final Jedis jedis;
    private static final int REDIS_5 = 5;

    protected RedisClient(RedisParameters redisParameters, Jedis jedis, int redisVersion) {
        this.redisParameters = redisParameters;
        this.batchSize = redisParameters.getBatchSize();
        this.jedis = jedis;
        this.redisVersion = redisVersion;
    }

    public ScanResult<String> scanKeys(String cursor, int batchSize, String keysPattern, RedisDataType type) {
        ScanParams scanParams = new ScanParams();
        scanParams.match(keysPattern);
        scanParams.count(batchSize);
        return this.scanByRedisVersion(cursor, scanParams, type, this.redisVersion);
    }

    private ScanResult<String> scanByRedisVersion(String cursor, ScanParams scanParams, RedisDataType type, Integer redisVersion) {
        if (redisVersion <= 5) {
            return this.scanOnRedis5(cursor, scanParams, type);
        }
        return this.jedis.scan(cursor, scanParams, type.name());
    }

    private ScanResult<String> scanOnRedis5(String cursor, ScanParams scanParams, RedisDataType type) {
        ScanResult<String> scanResult = this.jedis.scan(cursor, scanParams);
        String resultCursor = scanResult.getCursor();
        List<String> keys = scanResult.getResult();
        ArrayList<String> typeKeys = new ArrayList<String>(keys.size());
        for (String key : keys) {
            String keyType = this.jedis.type(key);
            if (!type.name().equalsIgnoreCase(keyType)) continue;
            typeKeys.add(key);
        }
        return new ScanResult<String>(resultCursor, typeKeys);
    }

    public abstract List<String> batchGetString(List<String> var1);

    public abstract List<List<String>> batchGetList(List<String> var1);

    public abstract List<Set<String>> batchGetSet(List<String> var1);

    public abstract List<Map<String, String>> batchGetHash(List<String> var1);

    public abstract List<List<String>> batchGetZset(List<String> var1);

    public abstract void batchWriteString(List<RowKind> var1, List<String> var2, List<String> var3, long var4);

    public abstract void batchWriteList(List<RowKind> var1, List<String> var2, List<String> var3, long var4);

    public abstract void batchWriteSet(List<RowKind> var1, List<String> var2, List<String> var3, long var4);

    public abstract void batchWriteHash(List<RowKind> var1, List<String> var2, List<String> var3, long var4);

    public abstract void batchWriteZset(List<RowKind> var1, List<String> var2, List<String> var3, long var4);
}

