/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.connectors.seatunnel.rabbitmq.source;

import com.google.auto.service.AutoService;
import java.io.Serializable;
import org.apache.seatunnel.api.configuration.Option;
import org.apache.seatunnel.api.configuration.ReadonlyConfig;
import org.apache.seatunnel.api.configuration.util.OptionRule;
import org.apache.seatunnel.api.source.SeaTunnelSource;
import org.apache.seatunnel.api.source.SourceSplit;
import org.apache.seatunnel.api.table.catalog.CatalogTableUtil;
import org.apache.seatunnel.api.table.connector.TableSource;
import org.apache.seatunnel.api.table.factory.Factory;
import org.apache.seatunnel.api.table.factory.TableSourceFactory;
import org.apache.seatunnel.api.table.factory.TableSourceFactoryContext;
import org.apache.seatunnel.connectors.seatunnel.rabbitmq.config.RabbitmqConfig;
import org.apache.seatunnel.connectors.seatunnel.rabbitmq.config.RabbitmqSinkOptions;
import org.apache.seatunnel.connectors.seatunnel.rabbitmq.config.RabbitmqSourceOptions;
import org.apache.seatunnel.connectors.seatunnel.rabbitmq.source.RabbitmqSource;

@AutoService(value={Factory.class})
public class RabbitmqSourceFactory
implements TableSourceFactory {
    public String factoryIdentifier() {
        return "RabbitMQ";
    }

    public OptionRule optionRule() {
        return OptionRule.builder().required(new Option[]{RabbitmqSourceOptions.HOST, RabbitmqSourceOptions.PORT, RabbitmqSourceOptions.VIRTUAL_HOST, RabbitmqSourceOptions.QUEUE_NAME, RabbitmqSourceOptions.SCHEMA}).bundled(new Option[]{RabbitmqSourceOptions.USERNAME, RabbitmqSourceOptions.PASSWORD}).optional(new Option[]{RabbitmqSourceOptions.URL, RabbitmqSourceOptions.ROUTING_KEY, RabbitmqSourceOptions.EXCHANGE, RabbitmqSourceOptions.NETWORK_RECOVERY_INTERVAL, RabbitmqSourceOptions.TOPOLOGY_RECOVERY_ENABLED, RabbitmqSourceOptions.AUTOMATIC_RECOVERY_ENABLED, RabbitmqSourceOptions.CONNECTION_TIMEOUT, RabbitmqSinkOptions.FOR_E2E_TESTING, RabbitmqSinkOptions.DURABLE, RabbitmqSinkOptions.EXCLUSIVE, RabbitmqSinkOptions.AUTO_DELETE, RabbitmqSourceOptions.REQUESTED_CHANNEL_MAX, RabbitmqSourceOptions.REQUESTED_FRAME_MAX, RabbitmqSourceOptions.REQUESTED_HEARTBEAT, RabbitmqSourceOptions.PREFETCH_COUNT, RabbitmqSourceOptions.DELIVERY_TIMEOUT}).build();
    }

    public <T, SplitT extends SourceSplit, StateT extends Serializable> TableSource<T, SplitT, StateT> createSource(TableSourceFactoryContext context) {
        return () -> new RabbitmqSource(new RabbitmqConfig(context.getOptions()), CatalogTableUtil.buildWithConfig((ReadonlyConfig)context.getOptions()));
    }

    public Class<? extends SeaTunnelSource> getSourceClass() {
        return RabbitmqSource.class;
    }
}

