/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.connectors.seatunnel.rabbitmq.client;

import com.rabbitmq.client.Channel;
import com.rabbitmq.client.Connection;
import com.rabbitmq.client.ConnectionFactory;
import com.rabbitmq.client.DefaultConsumer;
import com.rabbitmq.client.Delivery;
import java.io.IOException;
import java.net.URISyntaxException;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.util.concurrent.TimeoutException;
import org.apache.commons.lang3.StringUtils;
import org.apache.seatunnel.common.Handover;
import org.apache.seatunnel.common.exception.SeaTunnelErrorCode;
import org.apache.seatunnel.connectors.seatunnel.rabbitmq.client.QueueingConsumer;
import org.apache.seatunnel.connectors.seatunnel.rabbitmq.config.RabbitmqConfig;
import org.apache.seatunnel.connectors.seatunnel.rabbitmq.exception.RabbitmqConnectorErrorCode;
import org.apache.seatunnel.connectors.seatunnel.rabbitmq.exception.RabbitmqConnectorException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RabbitmqClient {
    private static final Logger log = LoggerFactory.getLogger(RabbitmqClient.class);
    private final RabbitmqConfig config;
    private final ConnectionFactory connectionFactory;
    private final Connection connection;
    private final Channel channel;

    public RabbitmqClient(RabbitmqConfig config) {
        this.config = config;
        try {
            this.connectionFactory = this.getConnectionFactory();
            this.connection = this.connectionFactory.newConnection();
            this.channel = this.connection.createChannel();
            if (config.getPrefetchCount() != null) {
                this.channel.basicQos(config.getPrefetchCount(), true);
            }
            this.setupQueue();
        }
        catch (Exception e) {
            throw new RabbitmqConnectorException(RabbitmqConnectorErrorCode.CREATE_RABBITMQ_CLIENT_FAILED, String.format("Error while create RMQ client with %s at %s", config.getQueueName(), config.getHost()), e);
        }
    }

    public Channel getChannel() {
        return this.channel;
    }

    public DefaultConsumer getQueueingConsumer(Handover<Delivery> handover) {
        QueueingConsumer consumer = new QueueingConsumer(this.channel, handover);
        return consumer;
    }

    public ConnectionFactory getConnectionFactory() {
        ConnectionFactory factory = new ConnectionFactory();
        if (!StringUtils.isEmpty((CharSequence)this.config.getUri())) {
            try {
                factory.setUri(this.config.getUri());
            }
            catch (URISyntaxException e) {
                throw new RabbitmqConnectorException((SeaTunnelErrorCode)RabbitmqConnectorErrorCode.PARSE_URI_FAILED, e);
            }
            catch (KeyManagementException e) {
                throw new RabbitmqConnectorException((SeaTunnelErrorCode)RabbitmqConnectorErrorCode.INIT_SSL_CONTEXT_FAILED, e);
            }
            catch (NoSuchAlgorithmException e) {
                throw new RabbitmqConnectorException((SeaTunnelErrorCode)RabbitmqConnectorErrorCode.SETUP_SSL_FACTORY_FAILED, e);
            }
        } else {
            factory.setHost(this.config.getHost());
            factory.setPort(this.config.getPort());
            factory.setVirtualHost(this.config.getVirtualHost());
            factory.setUsername(this.config.getUsername());
            factory.setPassword(this.config.getPassword());
        }
        if (this.config.getAutomaticRecovery() != null) {
            factory.setAutomaticRecoveryEnabled(this.config.getAutomaticRecovery());
        }
        if (this.config.getConnectionTimeout() != null) {
            factory.setConnectionTimeout(this.config.getConnectionTimeout());
        }
        if (this.config.getNetworkRecoveryInterval() != null) {
            factory.setNetworkRecoveryInterval(this.config.getNetworkRecoveryInterval());
        }
        if (this.config.getRequestedHeartbeat() != null) {
            factory.setRequestedHeartbeat(this.config.getRequestedHeartbeat());
        }
        if (this.config.getTopologyRecovery() != null) {
            factory.setTopologyRecoveryEnabled(this.config.getTopologyRecovery());
        }
        if (this.config.getRequestedChannelMax() != null) {
            factory.setRequestedChannelMax(this.config.getRequestedChannelMax());
        }
        if (this.config.getRequestedFrameMax() != null) {
            factory.setRequestedFrameMax(this.config.getRequestedFrameMax());
        }
        return factory;
    }

    public void write(byte[] msg) {
        try {
            if (StringUtils.isEmpty((CharSequence)this.config.getRoutingKey())) {
                this.channel.basicPublish("", this.config.getQueueName(), null, msg);
            } else {
                this.channel.basicPublish(this.config.getExchange(), this.config.getRoutingKey(), false, false, null, msg);
            }
        }
        catch (IOException e) {
            if (this.config.isLogFailuresOnly()) {
                log.error("Cannot send RMQ message {} at {}", new Object[]{this.config.getQueueName(), this.config.getHost(), e});
            }
            throw new RabbitmqConnectorException(RabbitmqConnectorErrorCode.SEND_MESSAGE_FAILED, String.format("Cannot send RMQ message %s at %s", this.config.getQueueName(), this.config.getHost()), e);
        }
    }

    public void close() {
        Exception t = null;
        try {
            if (this.channel != null) {
                this.channel.close();
            }
        }
        catch (IOException | TimeoutException e) {
            t = e;
        }
        try {
            if (this.connection != null) {
                this.connection.close();
            }
        }
        catch (IOException e) {
            if (t != null) {
                log.warn("Both channel and connection closing failed. Logging channel exception and failing with connection exception", (Throwable)t);
            }
            t = e;
        }
        if (t != null) {
            throw new RabbitmqConnectorException(RabbitmqConnectorErrorCode.CLOSE_CONNECTION_FAILED, String.format("Error while closing RMQ connection with  %s at %s", this.config.getQueueName(), this.config.getHost()), t);
        }
    }

    protected void setupQueue() throws IOException {
        if (this.config.getQueueName() != null) {
            this.declareQueueDefaults(this.channel, this.config);
        }
    }

    private void declareQueueDefaults(Channel channel, RabbitmqConfig config) throws IOException {
        channel.queueDeclare(config.getQueueName(), config.getDurable(), config.getExclusive(), config.getAutoDelete(), null);
    }

    public RabbitmqClient(RabbitmqConfig config, ConnectionFactory connectionFactory, Connection connection, Channel channel) {
        this.config = config;
        this.connectionFactory = connectionFactory;
        this.connection = connection;
        this.channel = channel;
    }
}

