/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.connectors.seatunnel.mongodb.serde;

import org.apache.seatunnel.api.table.type.SeaTunnelDataType;
import org.apache.seatunnel.api.table.type.SeaTunnelRow;
import org.apache.seatunnel.api.table.type.SeaTunnelRowType;
import org.apache.seatunnel.api.table.type.SqlType;
import org.apache.seatunnel.common.exception.CommonErrorCodeDeprecated;
import org.apache.seatunnel.common.exception.SeaTunnelErrorCode;
import org.apache.seatunnel.connectors.seatunnel.mongodb.exception.MongodbConnectorException;
import org.apache.seatunnel.connectors.seatunnel.mongodb.serde.BsonToRowDataConverters;
import org.apache.seatunnel.connectors.seatunnel.mongodb.serde.DocumentDeserializer;
import org.bson.BsonDocument;
import org.bson.BsonValue;

public class DocumentRowDataDeserializer
implements DocumentDeserializer<SeaTunnelRow> {
    private final String[] fieldNames;
    private final SeaTunnelDataType<?>[] fieldTypes;
    private final BsonToRowDataConverters bsonConverters;
    private final boolean flatSyncString;

    public DocumentRowDataDeserializer(String[] fieldNames, SeaTunnelDataType<?> dataTypes, boolean flatSyncString) {
        if (fieldNames == null || fieldNames.length < 1) {
            throw new MongodbConnectorException((SeaTunnelErrorCode)CommonErrorCodeDeprecated.ILLEGAL_ARGUMENT, "fieldName is empty");
        }
        this.bsonConverters = new BsonToRowDataConverters();
        this.fieldNames = fieldNames;
        this.fieldTypes = ((SeaTunnelRowType)dataTypes).getFieldTypes();
        this.flatSyncString = flatSyncString;
    }

    @Override
    public SeaTunnelRow deserialize(BsonDocument bsonDocument) {
        if (this.flatSyncString) {
            if (this.fieldNames.length != 1 && this.fieldTypes[0].getSqlType() != SqlType.STRING) {
                throw new MongodbConnectorException((SeaTunnelErrorCode)CommonErrorCodeDeprecated.UNSUPPORTED_OPERATION, "By utilizing flatSyncString, only one field attribute value can be set, and the field type must be a String. This operation will perform a string mapping on a single MongoDB data entry.");
            }
            SeaTunnelRow rowData = new SeaTunnelRow(this.fieldNames.length);
            rowData.setField(0, this.bsonConverters.createConverter(this.fieldTypes[0]).convert(bsonDocument));
            return rowData;
        }
        SeaTunnelRow rowData = new SeaTunnelRow(this.fieldNames.length);
        for (int i = 0; i < this.fieldNames.length; ++i) {
            String fieldName = this.fieldNames[i];
            BsonValue o = bsonDocument.get(fieldName);
            SeaTunnelDataType<?> fieldType = this.fieldTypes[i];
            rowData.setField(i, this.bsonConverters.createConverter(fieldType).convert(o));
        }
        return rowData;
    }
}

