/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.connectors.seatunnel.iotdb.sink;

import com.google.auto.service.AutoService;
import org.apache.seatunnel.api.configuration.Option;
import org.apache.seatunnel.api.configuration.util.OptionRule;
import org.apache.seatunnel.api.table.connector.TableSink;
import org.apache.seatunnel.api.table.factory.Factory;
import org.apache.seatunnel.api.table.factory.TableSinkFactory;
import org.apache.seatunnel.api.table.factory.TableSinkFactoryContext;
import org.apache.seatunnel.connectors.seatunnel.iotdb.config.IoTDBSinkOptions;
import org.apache.seatunnel.connectors.seatunnel.iotdb.sink.IoTDBSink;

@AutoService(value={Factory.class})
public class IoTDBSinkFactory
implements TableSinkFactory {
    public String factoryIdentifier() {
        return "IoTDB";
    }

    public OptionRule optionRule() {
        return OptionRule.builder().required(new Option[]{IoTDBSinkOptions.NODE_URLS, IoTDBSinkOptions.USERNAME, IoTDBSinkOptions.PASSWORD, IoTDBSinkOptions.KEY_DEVICE}).optional(new Option[]{IoTDBSinkOptions.KEY_TIMESTAMP, IoTDBSinkOptions.KEY_MEASUREMENT_FIELDS, IoTDBSinkOptions.STORAGE_GROUP, IoTDBSinkOptions.BATCH_SIZE, IoTDBSinkOptions.MAX_RETRIES, IoTDBSinkOptions.RETRY_BACKOFF_MULTIPLIER_MS, IoTDBSinkOptions.MAX_RETRY_BACKOFF_MS, IoTDBSinkOptions.DEFAULT_THRIFT_BUFFER_SIZE, IoTDBSinkOptions.MAX_THRIFT_FRAME_SIZE, IoTDBSinkOptions.ZONE_ID, IoTDBSinkOptions.ENABLE_RPC_COMPRESSION, IoTDBSinkOptions.CONNECTION_TIMEOUT_IN_MS}).build();
    }

    public TableSink createSink(TableSinkFactoryContext context) {
        return () -> new IoTDBSink(context.getOptions(), context.getCatalogTable());
    }
}

