/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.connectors.seatunnel.google.sheets.source;

import com.google.auto.service.AutoService;
import java.io.Serializable;
import org.apache.seatunnel.api.configuration.Option;
import org.apache.seatunnel.api.configuration.ReadonlyConfig;
import org.apache.seatunnel.api.configuration.util.OptionRule;
import org.apache.seatunnel.api.options.ConnectorCommonOptions;
import org.apache.seatunnel.api.source.SeaTunnelSource;
import org.apache.seatunnel.api.source.SourceSplit;
import org.apache.seatunnel.api.table.catalog.CatalogTable;
import org.apache.seatunnel.api.table.catalog.CatalogTableUtil;
import org.apache.seatunnel.api.table.connector.TableSource;
import org.apache.seatunnel.api.table.factory.Factory;
import org.apache.seatunnel.api.table.factory.TableSourceFactory;
import org.apache.seatunnel.api.table.factory.TableSourceFactoryContext;
import org.apache.seatunnel.connectors.seatunnel.google.sheets.config.SheetsParameters;
import org.apache.seatunnel.connectors.seatunnel.google.sheets.config.SheetsSourceOptions;
import org.apache.seatunnel.connectors.seatunnel.google.sheets.source.SheetsSource;

@AutoService(value={Factory.class})
public class SheetsSourceFactory
implements TableSourceFactory {
    public String factoryIdentifier() {
        return "GoogleSheets";
    }

    public OptionRule optionRule() {
        return OptionRule.builder().required(new Option[]{SheetsSourceOptions.SERVICE_ACCOUNT_KEY}).required(new Option[]{SheetsSourceOptions.SHEET_ID}).required(new Option[]{SheetsSourceOptions.SHEET_NAME}).required(new Option[]{SheetsSourceOptions.RANGE}).optional(new Option[]{ConnectorCommonOptions.SCHEMA}).build();
    }

    public <T, SplitT extends SourceSplit, StateT extends Serializable> TableSource<T, SplitT, StateT> createSource(TableSourceFactoryContext context) {
        CatalogTable catalogTable = context.getOptions().getOptional(ConnectorCommonOptions.SCHEMA).isPresent() ? CatalogTableUtil.buildWithConfig((ReadonlyConfig)context.getOptions()) : CatalogTableUtil.buildSimpleTextTable();
        return () -> new SheetsSource(catalogTable, new SheetsParameters().buildWithConfig(context.getOptions()));
    }

    public Class<? extends SeaTunnelSource> getSourceClass() {
        return SheetsSource.class;
    }
}

