/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.shade.connector.file.org.apache.parquet.hadoop.util;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.seatunnel.shade.connector.file.org.apache.parquet.ParquetReadOptions;
import org.apache.seatunnel.shade.connector.file.org.apache.parquet.bytes.BytesInput;
import org.apache.seatunnel.shade.connector.file.org.apache.parquet.column.ColumnDescriptor;
import org.apache.seatunnel.shade.connector.file.org.apache.parquet.column.impl.ColumnReadStoreImpl;
import org.apache.seatunnel.shade.connector.file.org.apache.parquet.column.page.DictionaryPage;
import org.apache.seatunnel.shade.connector.file.org.apache.parquet.column.page.PageReadStore;
import org.apache.seatunnel.shade.connector.file.org.apache.parquet.column.statistics.Statistics;
import org.apache.seatunnel.shade.connector.file.org.apache.parquet.compression.CompressionCodecFactory;
import org.apache.seatunnel.shade.connector.file.org.apache.parquet.format.DataPageHeader;
import org.apache.seatunnel.shade.connector.file.org.apache.parquet.format.DataPageHeaderV2;
import org.apache.seatunnel.shade.connector.file.org.apache.parquet.format.DictionaryPageHeader;
import org.apache.seatunnel.shade.connector.file.org.apache.parquet.format.PageHeader;
import org.apache.seatunnel.shade.connector.file.org.apache.parquet.format.Util;
import org.apache.seatunnel.shade.connector.file.org.apache.parquet.format.converter.ParquetMetadataConverter;
import org.apache.seatunnel.shade.connector.file.org.apache.parquet.hadoop.ParquetFileReader;
import org.apache.seatunnel.shade.connector.file.org.apache.parquet.hadoop.ParquetFileWriter;
import org.apache.seatunnel.shade.connector.file.org.apache.parquet.hadoop.metadata.BlockMetaData;
import org.apache.seatunnel.shade.connector.file.org.apache.parquet.hadoop.metadata.ColumnChunkMetaData;
import org.apache.seatunnel.shade.connector.file.org.apache.parquet.hadoop.metadata.ColumnPath;
import org.apache.seatunnel.shade.connector.file.org.apache.parquet.hadoop.metadata.CompressionCodecName;
import org.apache.seatunnel.shade.connector.file.org.apache.parquet.hadoop.metadata.ParquetMetadata;
import org.apache.seatunnel.shade.connector.file.org.apache.parquet.hadoop.util.HadoopCodecs;
import org.apache.seatunnel.shade.connector.file.org.apache.parquet.internal.column.columnindex.ColumnIndex;
import org.apache.seatunnel.shade.connector.file.org.apache.parquet.internal.column.columnindex.OffsetIndex;
import org.apache.seatunnel.shade.connector.file.org.apache.parquet.io.InputFile;
import org.apache.seatunnel.shade.connector.file.org.apache.parquet.io.ParquetEncodingException;
import org.apache.seatunnel.shade.connector.file.org.apache.parquet.io.SeekableInputStream;
import org.apache.seatunnel.shade.connector.file.org.apache.parquet.io.api.Converter;
import org.apache.seatunnel.shade.connector.file.org.apache.parquet.io.api.GroupConverter;
import org.apache.seatunnel.shade.connector.file.org.apache.parquet.io.api.PrimitiveConverter;
import org.apache.seatunnel.shade.connector.file.org.apache.parquet.schema.MessageType;
import org.apache.seatunnel.shade.connector.file.org.apache.parquet.schema.PrimitiveType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CompressionConverter {
    private static final Logger LOG = LoggerFactory.getLogger(CompressionConverter.class);
    private final int pageBufferSize = 0x200000;
    private byte[] pageBuffer = new byte[0x200000];

    public void processBlocks(TransParquetFileReader reader, ParquetFileWriter writer, ParquetMetadata meta, MessageType schema, String createdBy, CompressionCodecName codecName) throws IOException {
        int blockIndex = 0;
        PageReadStore store = reader.readNextRowGroup();
        while (store != null) {
            writer.startBlock(store.getRowCount());
            BlockMetaData blockMetaData = meta.getBlocks().get(blockIndex);
            List<ColumnChunkMetaData> columnsInOrder = blockMetaData.getColumns();
            Map<ColumnPath, ColumnDescriptor> descriptorsMap = schema.getColumns().stream().collect(Collectors.toMap(x -> ColumnPath.get(x.getPath()), x -> x));
            for (int i = 0; i < columnsInOrder.size(); ++i) {
                ColumnChunkMetaData chunk = columnsInOrder.get(i);
                ColumnReadStoreImpl crstore = new ColumnReadStoreImpl(store, new DummyGroupConverter(), schema, createdBy);
                ColumnDescriptor columnDescriptor = descriptorsMap.get(chunk.getPath());
                writer.startColumn(columnDescriptor, crstore.getColumnReader(columnDescriptor).getTotalValueCount(), codecName);
                this.processChunk(reader, writer, chunk, createdBy, codecName);
                writer.endColumn();
            }
            writer.endBlock();
            store = reader.readNextRowGroup();
            ++blockIndex;
        }
    }

    private void processChunk(TransParquetFileReader reader, ParquetFileWriter writer, ColumnChunkMetaData chunk, String createdBy, CompressionCodecName codecName) throws IOException {
        CompressionCodecFactory codecFactory = HadoopCodecs.newFactory(0);
        CompressionCodecFactory.BytesInputDecompressor decompressor = codecFactory.getDecompressor(chunk.getCodec());
        CompressionCodecFactory.BytesInputCompressor compressor = codecFactory.getCompressor(codecName);
        ColumnIndex columnIndex = reader.readColumnIndex(chunk);
        OffsetIndex offsetIndex = reader.readOffsetIndex(chunk);
        reader.setStreamPosition(chunk.getStartingPos());
        Object dictionaryPage = null;
        long readValues = 0L;
        Statistics statistics = null;
        ParquetMetadataConverter converter = new ParquetMetadataConverter();
        int pageIndex = 0;
        long totalChunkValues = chunk.getValueCount();
        block5: while (readValues < totalChunkValues) {
            PageHeader pageHeader = reader.readPageHeader();
            int compressedPageSize = pageHeader.getCompressed_page_size();
            switch (pageHeader.type) {
                case DICTIONARY_PAGE: {
                    if (dictionaryPage != null) {
                        throw new IOException("has more than one dictionary page in column chunk");
                    }
                    DictionaryPageHeader dictPageHeader = pageHeader.dictionary_page_header;
                    byte[] pageLoad = this.translatePageLoad(reader, true, compressor, decompressor, pageHeader.getCompressed_page_size(), pageHeader.getUncompressed_page_size());
                    writer.writeDictionaryPage(new DictionaryPage(BytesInput.from(pageLoad), pageHeader.getUncompressed_page_size(), dictPageHeader.getNum_values(), converter.getEncoding(dictPageHeader.getEncoding())));
                    continue block5;
                }
                case DATA_PAGE: {
                    DataPageHeader headerV1 = pageHeader.data_page_header;
                    byte[] pageLoad = this.translatePageLoad(reader, true, compressor, decompressor, pageHeader.getCompressed_page_size(), pageHeader.getUncompressed_page_size());
                    statistics = this.convertStatistics(createdBy, chunk.getPrimitiveType(), headerV1.getStatistics(), columnIndex, pageIndex, converter);
                    readValues += (long)headerV1.getNum_values();
                    if (offsetIndex != null) {
                        long rowCount = 1L + offsetIndex.getLastRowIndex(pageIndex, totalChunkValues) - offsetIndex.getFirstRowIndex(pageIndex);
                        writer.writeDataPage(this.toIntWithCheck(headerV1.getNum_values()), pageHeader.getUncompressed_page_size(), BytesInput.from(pageLoad), statistics, this.toIntWithCheck(rowCount), converter.getEncoding(headerV1.getRepetition_level_encoding()), converter.getEncoding(headerV1.getDefinition_level_encoding()), converter.getEncoding(headerV1.getEncoding()));
                    } else {
                        writer.writeDataPage(this.toIntWithCheck(headerV1.getNum_values()), pageHeader.getUncompressed_page_size(), BytesInput.from(pageLoad), statistics, converter.getEncoding(headerV1.getRepetition_level_encoding()), converter.getEncoding(headerV1.getDefinition_level_encoding()), converter.getEncoding(headerV1.getEncoding()));
                    }
                    ++pageIndex;
                    continue block5;
                }
                case DATA_PAGE_V2: {
                    DataPageHeaderV2 headerV2 = pageHeader.data_page_header_v2;
                    int rlLength = headerV2.getRepetition_levels_byte_length();
                    BytesInput rlLevels = this.readBlockAllocate(rlLength, reader);
                    int dlLength = headerV2.getDefinition_levels_byte_length();
                    BytesInput dlLevels = this.readBlockAllocate(dlLength, reader);
                    int payLoadLength = pageHeader.getCompressed_page_size() - rlLength - dlLength;
                    int rawDataLength = pageHeader.getUncompressed_page_size() - rlLength - dlLength;
                    byte[] pageLoad = this.translatePageLoad(reader, headerV2.is_compressed, compressor, decompressor, payLoadLength, rawDataLength);
                    statistics = this.convertStatistics(createdBy, chunk.getPrimitiveType(), headerV2.getStatistics(), columnIndex, pageIndex, converter);
                    readValues += (long)headerV2.getNum_values();
                    writer.writeDataPageV2(headerV2.getNum_rows(), headerV2.getNum_nulls(), headerV2.getNum_values(), rlLevels, dlLevels, converter.getEncoding(headerV2.getEncoding()), BytesInput.from(pageLoad), rawDataLength, statistics);
                    ++pageIndex;
                    continue block5;
                }
            }
            LOG.debug("skipping page of type {} of size {}", (Object)pageHeader.getType(), (Object)compressedPageSize);
        }
    }

    private Statistics convertStatistics(String createdBy, PrimitiveType type, org.apache.seatunnel.shade.connector.file.org.apache.parquet.format.Statistics pageStatistics, ColumnIndex columnIndex, int pageIndex, ParquetMetadataConverter converter) throws IOException {
        if (columnIndex != null) {
            if (columnIndex.getNullPages() == null) {
                throw new IOException("columnIndex has null variable 'nullPages' which indicates corrupted data for type: " + type.getName());
            }
            if (pageIndex > columnIndex.getNullPages().size()) {
                throw new IOException("There are more pages " + pageIndex + " found in the column than in the columnIndex " + columnIndex.getNullPages().size());
            }
            Statistics.Builder statsBuilder = Statistics.getBuilderForReading(type);
            statsBuilder.withNumNulls(columnIndex.getNullCounts().get(pageIndex));
            if (!columnIndex.getNullPages().get(pageIndex).booleanValue()) {
                statsBuilder.withMin((byte[])columnIndex.getMinValues().get(pageIndex).array().clone());
                statsBuilder.withMax((byte[])columnIndex.getMaxValues().get(pageIndex).array().clone());
            }
            return statsBuilder.build();
        }
        if (pageStatistics != null) {
            return converter.fromParquetStatistics(createdBy, pageStatistics, type);
        }
        return null;
    }

    private byte[] translatePageLoad(TransParquetFileReader reader, boolean isCompressed, CompressionCodecFactory.BytesInputCompressor compressor, CompressionCodecFactory.BytesInputDecompressor decompressor, int payloadLength, int rawDataLength) throws IOException {
        BytesInput data = this.readBlock(payloadLength, reader);
        if (isCompressed) {
            data = decompressor.decompress(data, rawDataLength);
        }
        BytesInput newCompressedData = compressor.compress(data);
        return newCompressedData.toByteArray();
    }

    public BytesInput readBlock(int length, TransParquetFileReader reader) throws IOException {
        byte[] data = length > 0x200000 ? new byte[length] : this.pageBuffer;
        reader.blockRead(data, 0, length);
        return BytesInput.from(data, 0, length);
    }

    public BytesInput readBlockAllocate(int length, TransParquetFileReader reader) throws IOException {
        byte[] data = new byte[length];
        reader.blockRead(data, 0, length);
        return BytesInput.from(data, 0, length);
    }

    private int toIntWithCheck(long size) {
        if ((long)((int)size) != size) {
            throw new ParquetEncodingException("size is bigger than 2147483647 bytes: " + size);
        }
        return (int)size;
    }

    public static final class TransParquetFileReader
    extends ParquetFileReader {
        public TransParquetFileReader(InputFile file, ParquetReadOptions options) throws IOException {
            super(file, options);
        }

        public void setStreamPosition(long newPos) throws IOException {
            this.f.seek(newPos);
        }

        public void blockRead(byte[] data, int start, int len) throws IOException {
            this.f.readFully(data, start, len);
        }

        public PageHeader readPageHeader() throws IOException {
            return Util.readPageHeader(this.f);
        }

        public long getPos() throws IOException {
            return this.f.getPos();
        }

        public SeekableInputStream getStream() {
            return this.f;
        }
    }

    private static final class DummyConverter
    extends PrimitiveConverter {
        private DummyConverter() {
        }

        @Override
        public GroupConverter asGroupConverter() {
            return new DummyGroupConverter();
        }
    }

    private static final class DummyGroupConverter
    extends GroupConverter {
        private DummyGroupConverter() {
        }

        @Override
        public void start() {
        }

        @Override
        public void end() {
        }

        @Override
        public Converter getConverter(int fieldIndex) {
            return new DummyConverter();
        }
    }
}

