/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.shade.connector.file.org.apache.parquet.hadoop;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.Function;
import org.apache.hadoop.conf.Configuration;

class ColumnConfigParser {
    private final List<ConfigHelper<?>> helpers = new ArrayList();

    ColumnConfigParser() {
    }

    public <T> ColumnConfigParser withColumnConfig(String rootKey, Function<String, T> function, BiConsumer<String, T> consumer) {
        this.helpers.add(new ConfigHelper<T>(rootKey + '#', function, consumer));
        return this;
    }

    public void parseConfig(Configuration conf) {
        for (Map.Entry entry : conf) {
            for (ConfigHelper<?> helper : this.helpers) {
                helper.processKey((String)entry.getKey());
            }
        }
    }

    private static class ConfigHelper<T> {
        private final String prefix;
        private final Function<String, T> function;
        private final BiConsumer<String, T> consumer;

        public ConfigHelper(String prefix, Function<String, T> function, BiConsumer<String, T> consumer) {
            this.prefix = prefix;
            this.function = function;
            this.consumer = consumer;
        }

        public void processKey(String key) {
            if (key.startsWith(this.prefix)) {
                String columnPath = key.substring(this.prefix.length());
                T value = this.function.apply(key);
                this.consumer.accept(columnPath, (String)value);
            }
        }
    }
}

