/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.shade.connector.file.org.apache.orc.impl;

import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.seatunnel.shade.connector.file.org.apache.orc.CompressionKind;
import org.apache.seatunnel.shade.connector.file.org.apache.orc.OrcConf;

public final class DataReaderProperties {
    private final FileSystem fileSystem;
    private final Path path;
    private final FSDataInputStream file;
    private final CompressionKind compression;
    private final boolean zeroCopy;
    private final int typeCount;
    private final int bufferSize;
    private final int maxDiskRangeChunkLimit;

    private DataReaderProperties(Builder builder) {
        this.fileSystem = builder.fileSystem;
        this.path = builder.path;
        this.file = builder.file;
        this.compression = builder.compression;
        this.zeroCopy = builder.zeroCopy;
        this.typeCount = builder.typeCount;
        this.bufferSize = builder.bufferSize;
        this.maxDiskRangeChunkLimit = builder.maxDiskRangeChunkLimit;
    }

    public FileSystem getFileSystem() {
        return this.fileSystem;
    }

    public Path getPath() {
        return this.path;
    }

    public FSDataInputStream getFile() {
        return this.file;
    }

    public CompressionKind getCompression() {
        return this.compression;
    }

    public boolean getZeroCopy() {
        return this.zeroCopy;
    }

    public int getTypeCount() {
        return this.typeCount;
    }

    public int getBufferSize() {
        return this.bufferSize;
    }

    public int getMaxDiskRangeChunkLimit() {
        return this.maxDiskRangeChunkLimit;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private FileSystem fileSystem;
        private Path path;
        private FSDataInputStream file;
        private CompressionKind compression;
        private boolean zeroCopy;
        private int typeCount;
        private int bufferSize;
        private int maxDiskRangeChunkLimit = (Integer)OrcConf.ORC_MAX_DISK_RANGE_CHUNK_LIMIT.getDefaultValue();

        private Builder() {
        }

        public Builder withFileSystem(FileSystem fileSystem) {
            this.fileSystem = fileSystem;
            return this;
        }

        public Builder withPath(Path path) {
            this.path = path;
            return this;
        }

        public Builder withFile(FSDataInputStream file) {
            this.file = file;
            return this;
        }

        public Builder withCompression(CompressionKind value) {
            this.compression = value;
            return this;
        }

        public Builder withZeroCopy(boolean zeroCopy) {
            this.zeroCopy = zeroCopy;
            return this;
        }

        public Builder withTypeCount(int value) {
            this.typeCount = value;
            return this;
        }

        public Builder withBufferSize(int value) {
            this.bufferSize = value;
            return this;
        }

        public Builder withMaxDiskRangeChunkLimit(int value) {
            this.maxDiskRangeChunkLimit = value;
            return this;
        }

        public DataReaderProperties build() {
            if (this.fileSystem == null || this.path == null) {
                throw new NullPointerException("Filesystem = " + this.fileSystem + ", path = " + this.path);
            }
            return new DataReaderProperties(this);
        }
    }
}

