/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.connectors.seatunnel.file.s3.config;

import java.util.Map;
import org.apache.seatunnel.api.configuration.Option;
import org.apache.seatunnel.api.configuration.Options;
import org.apache.seatunnel.connectors.seatunnel.file.config.BaseSourceConfigOptions;

public class S3ConfigOptions
extends BaseSourceConfigOptions {
    public static final Option<String> S3_ACCESS_KEY = Options.key((String)"access_key").stringType().noDefaultValue().withDescription("S3 access key");
    public static final Option<String> S3_SECRET_KEY = Options.key((String)"secret_key").stringType().noDefaultValue().withDescription("S3 secret key");
    public static final Option<String> S3_BUCKET = Options.key((String)"bucket").stringType().noDefaultValue().withDescription("S3 bucket");
    public static final Option<String> FS_S3A_ENDPOINT = Options.key((String)"fs.s3a.endpoint").stringType().noDefaultValue().withDescription("fs s3a endpoint");
    public static final Option<S3aAwsCredentialsProvider> S3A_AWS_CREDENTIALS_PROVIDER = Options.key((String)"fs.s3a.aws.credentials.provider").enumType(S3aAwsCredentialsProvider.class).defaultValue((Object)S3aAwsCredentialsProvider.InstanceProfileCredentialsProvider).withDescription("s3a aws credentials provider");
    public static final Option<Map<String, String>> S3_PROPERTIES = Options.key((String)"hadoop_s3_properties").mapType().noDefaultValue().withDescription("S3 properties");

    public static enum S3aAwsCredentialsProvider {
        SimpleAWSCredentialsProvider("org.apache.hadoop.fs.s3a.SimpleAWSCredentialsProvider"),
        InstanceProfileCredentialsProvider("com.amazonaws.auth.InstanceProfileCredentialsProvider");

        private String provider;

        private S3aAwsCredentialsProvider(String provider) {
            this.provider = provider;
        }

        public String getProvider() {
            return this.provider;
        }

        public String toString() {
            return this.provider;
        }
    }
}

