/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.excel.enums;

import com.alibaba.excel.util.MapUtils;
import java.nio.charset.Charset;
import java.util.Map;
import org.apache.commons.io.ByteOrderMark;

public enum ByteOrderMarkEnum {
    UTF_8(ByteOrderMark.UTF_8),
    UTF_16BE(ByteOrderMark.UTF_16BE),
    UTF_16LE(ByteOrderMark.UTF_16LE),
    UTF_32BE(ByteOrderMark.UTF_32BE),
    UTF_32LE(ByteOrderMark.UTF_32LE);

    final ByteOrderMark byteOrderMark;
    final String stringPrefix;
    private static final Map<String, ByteOrderMarkEnum> CHARSET_BYTE_ORDER_MARK_MAP;

    private ByteOrderMarkEnum(ByteOrderMark byteOrderMark) {
        this.byteOrderMark = byteOrderMark;
        Charset charset = Charset.forName(byteOrderMark.getCharsetName());
        this.stringPrefix = new String(byteOrderMark.getBytes(), charset);
    }

    public static ByteOrderMarkEnum valueOfByCharsetName(String charsetName) {
        return CHARSET_BYTE_ORDER_MARK_MAP.get(charsetName);
    }

    public ByteOrderMark getByteOrderMark() {
        return this.byteOrderMark;
    }

    public String getStringPrefix() {
        return this.stringPrefix;
    }

    static {
        CHARSET_BYTE_ORDER_MARK_MAP = MapUtils.newHashMap();
        for (ByteOrderMarkEnum value : ByteOrderMarkEnum.values()) {
            CHARSET_BYTE_ORDER_MARK_MAP.put(value.getByteOrderMark().getCharsetName(), value);
        }
    }
}

