/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.datahub.client.impl.request.protobuf;

import com.aliyun.datahub.client.http.HttpConfig;
import com.aliyun.datahub.client.http.converter.BaseProtobufModel;
import com.aliyun.datahub.client.http.converter.batch.BatchUtil;
import com.aliyun.datahub.client.model.RecordEntry;
import com.aliyun.datahub.client.model.protobuf.DatahubProtos;
import com.aliyun.datahub.shaded.com.google.protobuf.ByteString;
import com.aliyun.datahub.shaded.com.google.protobuf.Message;
import java.util.List;

public class PutBatchRecordsRequestPB
implements BaseProtobufModel {
    private DatahubProtos.PutBinaryRecordsRequest.Builder reqBuilder = DatahubProtos.PutBinaryRecordsRequest.newBuilder();
    private HttpConfig.CompressType compressType;

    public PutBatchRecordsRequestPB(HttpConfig.CompressType compressType) {
        this.compressType = compressType;
    }

    public PutBatchRecordsRequestPB setRecords(List<RecordEntry> records) {
        byte[] batchBuffer = BatchUtil.serialize(records, this.compressType);
        DatahubProtos.BinaryRecordEntry.Builder recordBuilder = DatahubProtos.BinaryRecordEntry.newBuilder();
        recordBuilder.setData(ByteString.copyFrom(batchBuffer));
        this.reqBuilder.addRecords(recordBuilder.build());
        return this;
    }

    @Override
    public Message getMessage() {
        return this.reqBuilder.build();
    }

    @Override
    public void setMessage(Message message) {
    }

    @Override
    public String getContentType() {
        return "application/x-binary";
    }
}

