/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.datahub.client.impl.interceptor;

import com.aliyun.datahub.client.auth.Account;
import com.aliyun.datahub.client.common.DateFormat;
import com.aliyun.datahub.client.http.interceptor.AuthInterceptor;
import com.aliyun.datahub.shaded.okhttp3.Interceptor;
import com.aliyun.datahub.shaded.okhttp3.MediaType;
import com.aliyun.datahub.shaded.okhttp3.Request;
import com.aliyun.datahub.shaded.okhttp3.RequestBody;
import com.aliyun.datahub.shaded.okhttp3.Response;
import java.io.IOException;
import java.lang.management.ManagementFactory;
import java.net.Inet4Address;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.util.Date;
import java.util.Enumeration;
import java.util.Locale;
import java.util.Properties;
import java.util.Set;

public class DatahubAuthInterceptor
extends AuthInterceptor {
    private String userAgent;
    private static String ipAddress = DatahubAuthInterceptor.getIpAddress();
    private static String clientId = DatahubAuthInterceptor.getClientId();

    public DatahubAuthInterceptor(Account account, String userAgent) {
        super(account);
        this.userAgent = userAgent;
    }

    @Override
    public Response intercept(Interceptor.Chain chain) throws IOException {
        Request request = chain.request();
        Request.Builder reqBuilder = request.newBuilder();
        this.addEssentialHeaders(request, reqBuilder);
        return chain.proceed(reqBuilder.build());
    }

    private void addEssentialHeaders(Request request, Request.Builder reqBuilder) {
        MediaType contentType;
        RequestBody body;
        Set<String> headerNames = request.headers().names();
        if (!headerNames.contains("x-datahub-client-version")) {
            reqBuilder.addHeader("x-datahub-client-version", "1.1");
        }
        if (!headerNames.contains("Date")) {
            reqBuilder.addHeader("Date", DateFormat.getDateTimeFormat().format(new Date()));
        }
        if ((body = request.body()) != null && (contentType = body.contentType()) != null) {
            reqBuilder.addHeader("Content-Type", contentType.toString());
        }
        if (ipAddress != null) {
            reqBuilder.addHeader("x-datahub-source-ip", ipAddress);
        }
        String clientAgent = null;
        if (clientId != null) {
            clientAgent = this.userAgent == null ? clientId : clientId + "-" + this.userAgent;
        } else if (this.userAgent != null) {
            clientAgent = this.userAgent;
        }
        if (clientAgent != null) {
            reqBuilder.addHeader("User-Agent", clientAgent);
        }
        this.account.addAuthHeaders(reqBuilder);
    }

    private static String getIpAddress() {
        String ip = null;
        Enumeration<NetworkInterface> interfaces = null;
        try {
            interfaces = NetworkInterface.getNetworkInterfaces();
        }
        catch (SocketException e) {
            throw new RuntimeException(e);
        }
        while (interfaces.hasMoreElements()) {
            NetworkInterface element = interfaces.nextElement();
            Enumeration<InetAddress> addresses = element.getInetAddresses();
            while (addresses.hasMoreElements()) {
                InetAddress address = addresses.nextElement();
                if (address.isLoopbackAddress() || !(address instanceof Inet4Address)) continue;
                ip = address.getHostAddress();
            }
        }
        return ip;
    }

    private static String getClientId() {
        String path = "META-INF/maven/com.aliyun.datahub/aliyun-sdk-datahub/pom.properties";
        Properties p = new Properties();
        try {
            p.load(DatahubAuthInterceptor.class.getClassLoader().getResourceAsStream(path));
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        String versionNumber = p.getProperty("version", "Unknown");
        String processName = ManagementFactory.getRuntimeMXBean().getName();
        String processId = processName.substring(0, processName.indexOf(64));
        return String.format(Locale.ENGLISH, "%s@%s-(Java-%s)", ipAddress, processId, versionNumber);
    }
}

