/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.datahub.client.http.converter;

import com.aliyun.datahub.client.model.BaseResult;
import com.aliyun.datahub.shaded.okhttp3.RequestBody;
import com.aliyun.datahub.shaded.okhttp3.ResponseBody;
import com.aliyun.datahub.shaded.retrofit2.Converter;
import com.aliyun.datahub.shaded.retrofit2.Retrofit;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.annotation.Nullable;

public class EmptyBodyConverterFactory
extends Converter.Factory {
    public static EmptyBodyConverterFactory create() {
        return new EmptyBodyConverterFactory();
    }

    @Override
    @Nullable
    public Converter<ResponseBody, ?> responseBodyConverter(Type type, Annotation[] annotations, Retrofit retrofit) {
        List<Field> fields;
        if (!(type instanceof Class)) {
            return null;
        }
        Class cls = (Class)type;
        if (BaseResult.class.isAssignableFrom(cls) && (fields = this.getAllFields(cls)).size() >= 1) {
            int dataFields = 0;
            for (Field field : fields) {
                if ("requestId".equalsIgnoreCase(field.getName()) || field.getName().contains("$") || Modifier.isStatic(field.getModifiers())) continue;
                ++dataFields;
            }
            if (dataFields == 0) {
                return new EmptyBodyResponseBodyConverter(cls);
            }
        }
        return null;
    }

    @Override
    @Nullable
    public Converter<?, RequestBody> requestBodyConverter(Type type, Annotation[] parameterAnnotations, Annotation[] methodAnnotations, Retrofit retrofit) {
        return null;
    }

    private List<Field> getAllFields(Class cls) {
        ArrayList<Field> fields = new ArrayList<Field>();
        while (cls != null) {
            fields.addAll(Arrays.asList(cls.getDeclaredFields()));
            cls = cls.getSuperclass();
        }
        return fields;
    }

    private static class EmptyBodyResponseBodyConverter<T>
    implements Converter<ResponseBody, T> {
        private Class<T> retCls;

        EmptyBodyResponseBodyConverter(Class<T> cls) {
            this.retCls = cls;
        }

        @Override
        @Nullable
        public T convert(ResponseBody value) throws IOException {
            value.close();
            try {
                return this.retCls.newInstance();
            }
            catch (Exception e) {
                return null;
            }
        }
    }
}

