/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.connectors.seatunnel.datahub.sink;

import java.io.IOException;
import java.util.Optional;
import org.apache.seatunnel.api.configuration.ReadonlyConfig;
import org.apache.seatunnel.api.sink.SinkWriter;
import org.apache.seatunnel.api.table.catalog.CatalogTable;
import org.apache.seatunnel.api.table.type.SeaTunnelRow;
import org.apache.seatunnel.connectors.seatunnel.common.sink.AbstractSimpleSink;
import org.apache.seatunnel.connectors.seatunnel.common.sink.AbstractSinkWriter;
import org.apache.seatunnel.connectors.seatunnel.datahub.config.DataHubSinkOptions;
import org.apache.seatunnel.connectors.seatunnel.datahub.sink.DataHubWriter;

public class DataHubSink
extends AbstractSimpleSink<SeaTunnelRow, Void> {
    private final ReadonlyConfig pluginConfig;
    private final CatalogTable catalogTable;

    public DataHubSink(ReadonlyConfig pluginConfig, CatalogTable catalogTable) {
        this.pluginConfig = pluginConfig;
        this.catalogTable = catalogTable;
    }

    public String getPluginName() {
        return "DataHub";
    }

    @Override
    public AbstractSinkWriter<SeaTunnelRow, Void> createWriter(SinkWriter.Context context) throws IOException {
        return new DataHubWriter(this.catalogTable.getSeaTunnelRowType(), (String)this.pluginConfig.get(DataHubSinkOptions.ENDPOINT), (String)this.pluginConfig.get(DataHubSinkOptions.ACCESS_ID), (String)this.pluginConfig.get(DataHubSinkOptions.ACCESS_KEY), (String)this.pluginConfig.get(DataHubSinkOptions.PROJECT), (String)this.pluginConfig.get(DataHubSinkOptions.TOPIC), (Integer)this.pluginConfig.get(DataHubSinkOptions.TIMEOUT), (Integer)this.pluginConfig.get(DataHubSinkOptions.RETRY_TIMES));
    }

    public Optional<CatalogTable> getWriteCatalogTable() {
        return Optional.of(this.catalogTable);
    }
}

