/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.datahub.shaded.retrofit2.converter.jackson;

import com.aliyun.datahub.shaded.okhttp3.MediaType;
import com.aliyun.datahub.shaded.okhttp3.RequestBody;
import com.aliyun.datahub.shaded.retrofit2.Converter;
import com.fasterxml.jackson.databind.ObjectWriter;
import java.io.IOException;

final class JacksonRequestBodyConverter<T>
implements Converter<T, RequestBody> {
    private static final MediaType MEDIA_TYPE = MediaType.get("application/json; charset=UTF-8");
    private final ObjectWriter adapter;

    JacksonRequestBodyConverter(ObjectWriter adapter) {
        this.adapter = adapter;
    }

    @Override
    public RequestBody convert(T value) throws IOException {
        byte[] bytes = this.adapter.writeValueAsBytes(value);
        return RequestBody.create(MEDIA_TYPE, bytes);
    }
}

